/*
 * Decompiled with CFR 0.152.
 */
package jakarta.xml.bind;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Messages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

class ModuleUtil {
    private static final Logger LOGGER = Logger.getLogger("jakarta.xml.bind");
    private static final boolean JPMS_SUPPORTED;

    ModuleUtil() {
    }

    static Class<?>[] getClassesFromContextPath(String contextPath, ClassLoader classLoader) throws JAXBException {
        String[] tokens;
        ArrayList classes2 = new ArrayList();
        if (contextPath == null || contextPath.isEmpty()) {
            return classes2.toArray(new Class[0]);
        }
        for (String pkg : tokens = contextPath.split(":")) {
            try {
                Class<?> o = classLoader.loadClass(pkg + ".ObjectFactory");
                classes2.add(o);
            }
            catch (ClassNotFoundException o) {
                try {
                    Class<?> firstByJaxbIndex = ModuleUtil.findFirstByJaxbIndex(pkg, classLoader);
                    if (firstByJaxbIndex == null) continue;
                    classes2.add(firstByJaxbIndex);
                }
                catch (IOException e) {
                    throw new JAXBException(e);
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Resolved classes from context path: {0}", classes2);
        }
        return classes2.toArray(new Class[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Class<?> findFirstByJaxbIndex(String pkg, ClassLoader classLoader) throws IOException, JAXBException {
        String resource = pkg.replace('.', '/') + "/jaxb.index";
        InputStream resourceAsStream = classLoader.getResourceAsStream(resource);
        if (resourceAsStream == null) {
            return null;
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8));){
            String className = in.readLine();
            while (className != null) {
                if ((className = className.trim()).startsWith("#") || className.isEmpty()) {
                    className = in.readLine();
                    continue;
                }
                try {
                    Class<?> clazz = classLoader.loadClass(pkg + "." + className);
                    return clazz;
                }
                catch (ClassNotFoundException e) {
                    try {
                        throw new JAXBException(Messages.format("ContextFinder.ErrorLoadClass", className, pkg), e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return null;
                    }
                }
            }
        }
    }

    public static void delegateAddOpensToImplModule(Class<?>[] classes2, Class<?> factorySPI) throws JAXBException {
        if (JPMS_SUPPORTED) {
            Module implModule = factorySPI.getModule();
            Module jaxbModule = JAXBContext.class.getModule();
            if (!jaxbModule.isNamed()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Using jakarta.xml.bind-api on the class path.");
                }
                return;
            }
            for (Class<?> cls : classes2) {
                Class<?> jaxbClass = cls.isArray() ? cls.getComponentType() : cls;
                Module classModule = jaxbClass.getModule();
                String packageName = jaxbClass.getPackageName();
                if (!classModule.isNamed() || classModule.getName().equals("java.base")) continue;
                if (!classModule.isOpen(packageName, jaxbModule)) {
                    throw new JAXBException(Messages.format("JAXBClasses.notOpen", packageName, jaxbClass.getName(), classModule.getName()));
                }
                classModule.addOpens(packageName, implModule);
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, "Propagating openness of package {0} in {1} to {2}.", new String[]{packageName, classModule.getName(), implModule.getName()});
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Using jakarta.xml.bind-api with no JPMS related APIs, such as Class::getModule.");
        }
    }

    static {
        boolean b = false;
        try {
            JAXBContext.class.getModule();
            b = true;
        }
        catch (NoSuchMethodError nsme) {
            b = false;
        }
        JPMS_SUPPORTED = b;
    }
}

