/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.Buffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import jnr.ffi.Address;
import jnr.ffi.NativeType;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.Type;
import jnr.ffi.annotations.TypeDefinition;

class Types {
    private static Reference<Map<Class, Map<Collection<Annotation>, Type>>> typeCacheReference;

    Types() {
    }

    static Type getType(Runtime runtime, Class javaType, Collection<Annotation> annotations2) {
        Map<Class, Map<Collection<Annotation>, Type>> cache2 = typeCacheReference != null ? typeCacheReference.get() : null;
        Map<Collection<Annotation>, Type> aliasCache = cache2 != null ? cache2.get(javaType) : null;
        Type type2 = aliasCache != null ? aliasCache.get(annotations2) : null;
        return type2 != null ? type2 : Types.lookupAndCacheType(runtime, javaType, annotations2);
    }

    private static synchronized Type lookupAndCacheType(Runtime runtime, Class javaType, Collection<Annotation> annotations2) {
        Type type2;
        HashMap cache2 = typeCacheReference != null ? typeCacheReference.get() : null;
        HashMap<Collection<Annotation>, Type> aliasCache = cache2 != null ? cache2.get(javaType) : null;
        Type type3 = type2 = aliasCache != null ? aliasCache.get(annotations2) : null;
        if (type2 != null) {
            return type2;
        }
        cache2 = new HashMap(cache2 != null ? cache2 : Collections.EMPTY_MAP);
        aliasCache = new HashMap<Collection<Annotation>, Type>(aliasCache != null ? aliasCache : Collections.EMPTY_MAP);
        type2 = Types.lookupType(runtime, javaType, annotations2);
        aliasCache.put(annotations2, type2);
        cache2.put(javaType, Collections.unmodifiableMap(aliasCache));
        typeCacheReference = new SoftReference(Collections.unmodifiableMap(new IdentityHashMap(cache2)));
        return type2;
    }

    private static Type lookupAliasedType(Runtime runtime, Collection<Annotation> annotations2) {
        for (Annotation a : annotations2) {
            TypeDefinition typedef = a.annotationType().getAnnotation(TypeDefinition.class);
            if (typedef == null) continue;
            return runtime.findType(typedef.alias());
        }
        return null;
    }

    static Type lookupType(Runtime runtime, Class type2, Collection<Annotation> annotations2) {
        Type aliasedType;
        Type type3 = aliasedType = type2.isArray() ? null : Types.lookupAliasedType(runtime, annotations2);
        if (aliasedType != null) {
            return aliasedType;
        }
        if (Void.class.isAssignableFrom(type2) || Void.TYPE == type2) {
            return runtime.findType(NativeType.VOID);
        }
        if (Boolean.class.isAssignableFrom(type2) || Boolean.TYPE == type2) {
            return runtime.findType(NativeType.SINT);
        }
        if (Byte.class.isAssignableFrom(type2) || Byte.TYPE == type2) {
            return runtime.findType(NativeType.SCHAR);
        }
        if (Short.class.isAssignableFrom(type2) || Short.TYPE == type2) {
            return runtime.findType(NativeType.SSHORT);
        }
        if (Integer.class.isAssignableFrom(type2) || Integer.TYPE == type2) {
            return runtime.findType(NativeType.SINT);
        }
        if (Long.class.isAssignableFrom(type2) || Long.TYPE == type2) {
            return runtime.findType(NativeType.SLONG);
        }
        if (Float.class.isAssignableFrom(type2) || Float.TYPE == type2) {
            return runtime.findType(NativeType.FLOAT);
        }
        if (Double.class.isAssignableFrom(type2) || Double.TYPE == type2) {
            return runtime.findType(NativeType.DOUBLE);
        }
        if (Pointer.class.isAssignableFrom(type2)) {
            return runtime.findType(NativeType.ADDRESS);
        }
        if (Address.class.isAssignableFrom(type2)) {
            return runtime.findType(NativeType.ADDRESS);
        }
        if (Buffer.class.isAssignableFrom(type2)) {
            return runtime.findType(NativeType.ADDRESS);
        }
        if (CharSequence.class.isAssignableFrom(type2)) {
            return runtime.findType(NativeType.ADDRESS);
        }
        if (type2.isArray()) {
            return runtime.findType(NativeType.ADDRESS);
        }
        throw new IllegalArgumentException("unsupported type: " + type2);
    }
}

