/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheInterceptor;
import okhttp3.internal.connection.ConnectInterceptor;
import okhttp3.internal.connection.Transmitter;
import okhttp3.internal.http.BridgeInterceptor;
import okhttp3.internal.http.CallServerInterceptor;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http.RetryAndFollowUpInterceptor;
import okhttp3.internal.platform.Platform;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 '2\u00020\u0001:\u0002&'B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0000H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0006\u0010\u001d\u001a\u00020\u001cJ\b\u0010\u001e\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020\u0007H\u0016J\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020\u0005H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0006\u0010%\u001a\u00020!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lokhttp3/RealCall;", "Lokhttp3/Call;", "client", "Lokhttp3/OkHttpClient;", "originalRequest", "Lokhttp3/Request;", "forWebSocket", "", "(Lokhttp3/OkHttpClient;Lokhttp3/Request;Z)V", "getClient", "()Lokhttp3/OkHttpClient;", "executed", "getExecuted", "()Z", "setExecuted", "(Z)V", "getForWebSocket", "getOriginalRequest", "()Lokhttp3/Request;", "transmitter", "Lokhttp3/internal/connection/Transmitter;", "cancel", "", "clone", "enqueue", "responseCallback", "Lokhttp3/Callback;", "execute", "Lokhttp3/Response;", "getResponseWithInterceptorChain", "isCanceled", "isExecuted", "redactedUrl", "", "request", "timeout", "Lokio/Timeout;", "toLoggableString", "AsyncCall", "Companion", "okhttp"})
public final class RealCall
implements Call {
    private Transmitter transmitter;
    private boolean executed;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final Request originalRequest;
    private final boolean forWebSocket;
    public static final Companion Companion = new Companion(null);

    public final boolean getExecuted() {
        return this.executed;
    }

    public final void setExecuted(boolean bl) {
        this.executed = bl;
    }

    @Override
    public synchronized boolean isExecuted() {
        return this.executed;
    }

    @Override
    public boolean isCanceled() {
        Transmitter transmitter = this.transmitter;
        if (transmitter == null) {
            Intrinsics.throwUninitializedPropertyAccessException("transmitter");
        }
        return transmitter.isCanceled();
    }

    @Override
    @NotNull
    public Request request() {
        return this.originalRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Response execute() {
        Object object = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            boolean bl4 = !this.executed;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "Already Executed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.executed = true;
            Unit unit = Unit.INSTANCE;
        }
        Transmitter transmitter = this.transmitter;
        if (transmitter == null) {
            Intrinsics.throwUninitializedPropertyAccessException("transmitter");
        }
        transmitter.timeoutEnter();
        Transmitter transmitter2 = this.transmitter;
        if (transmitter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("transmitter");
        }
        transmitter2.callStart();
        try {
            this.client.dispatcher().executed$okhttp(this);
            object = this.getResponseWithInterceptorChain();
            return object;
        }
        finally {
            this.client.dispatcher().finished$okhttp(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(@NotNull Callback responseCallback) {
        Intrinsics.checkParameterIsNotNull(responseCallback, "responseCallback");
        RealCall realCall = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realCall) {
            boolean bl3 = false;
            boolean bl4 = !this.executed;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "Already Executed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.executed = true;
            Unit unit = Unit.INSTANCE;
        }
        Transmitter transmitter = this.transmitter;
        if (transmitter == null) {
            Intrinsics.throwUninitializedPropertyAccessException("transmitter");
        }
        transmitter.callStart();
        this.client.dispatcher().enqueue$okhttp(new AsyncCall(responseCallback));
    }

    @Override
    public void cancel() {
        Transmitter transmitter = this.transmitter;
        if (transmitter == null) {
            Intrinsics.throwUninitializedPropertyAccessException("transmitter");
        }
        transmitter.cancel();
    }

    @Override
    @NotNull
    public Timeout timeout() {
        Transmitter transmitter = this.transmitter;
        if (transmitter == null) {
            Intrinsics.throwUninitializedPropertyAccessException("transmitter");
        }
        return transmitter.timeout();
    }

    @Override
    @NotNull
    public RealCall clone() {
        return Companion.newRealCall(this.client, this.originalRequest, this.forWebSocket);
    }

    @NotNull
    public final String toLoggableString() {
        return (this.isCanceled() ? "canceled " : "") + (this.forWebSocket ? "web socket" : "call") + " to " + this.redactedUrl();
    }

    @NotNull
    public final String redactedUrl() {
        return this.originalRequest.url().redact();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Response getResponseWithInterceptorChain() throws IOException {
        Response response;
        boolean bl = false;
        List interceptors = new ArrayList();
        Collection collection = interceptors;
        Object object = this.client.interceptors();
        boolean bl2 = false;
        CollectionsKt.addAll(collection, object);
        collection = interceptors;
        object = new RetryAndFollowUpInterceptor(this.client);
        bl2 = false;
        collection.add(object);
        collection = interceptors;
        object = new BridgeInterceptor(this.client.cookieJar());
        bl2 = false;
        collection.add(object);
        collection = interceptors;
        object = new CacheInterceptor(this.client.cache());
        bl2 = false;
        collection.add(object);
        collection = interceptors;
        object = ConnectInterceptor.INSTANCE;
        bl2 = false;
        collection.add(object);
        if (!this.forWebSocket) {
            collection = interceptors;
            object = this.client.networkInterceptors();
            bl2 = false;
            CollectionsKt.addAll(collection, object);
        }
        collection = interceptors;
        object = new CallServerInterceptor(this.forWebSocket);
        bl2 = false;
        collection.add(object);
        Transmitter transmitter = this.transmitter;
        if (transmitter == null) {
            Intrinsics.throwUninitializedPropertyAccessException("transmitter");
        }
        RealInterceptorChain chain = new RealInterceptorChain(interceptors, transmitter, null, 0, this.originalRequest, this, this.client.connectTimeoutMillis(), this.client.readTimeoutMillis(), this.client.writeTimeoutMillis());
        boolean calledNoMoreExchanges = false;
        try {
            Response response2 = chain.proceed(this.originalRequest);
            Transmitter transmitter2 = this.transmitter;
            if (transmitter2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("transmitter");
            }
            if (transmitter2.isCanceled()) {
                Util.closeQuietly(response2);
                throw (Throwable)new IOException("Canceled");
            }
            response = response2;
        }
        catch (IOException e) {
            try {
                calledNoMoreExchanges = true;
                Transmitter transmitter3 = this.transmitter;
                if (transmitter3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("transmitter");
                }
                IOException iOException = transmitter3.noMoreExchanges(e);
                if (iOException == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Throwable");
                }
                throw (Throwable)iOException;
            }
            catch (Throwable throwable) {
                if (!calledNoMoreExchanges) {
                    Transmitter transmitter4 = this.transmitter;
                    if (transmitter4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("transmitter");
                    }
                    transmitter4.noMoreExchanges(null);
                }
                throw throwable;
            }
        }
        Transmitter transmitter5 = this.transmitter;
        if (transmitter5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("transmitter");
        }
        transmitter5.noMoreExchanges(null);
        return response;
    }

    @NotNull
    public final OkHttpClient getClient() {
        return this.client;
    }

    @NotNull
    public final Request getOriginalRequest() {
        return this.originalRequest;
    }

    public final boolean getForWebSocket() {
        return this.forWebSocket;
    }

    private RealCall(OkHttpClient client, Request originalRequest, boolean forWebSocket) {
        this.client = client;
        this.originalRequest = originalRequest;
        this.forWebSocket = forWebSocket;
    }

    public static final /* synthetic */ Transmitter access$getTransmitter$p(RealCall $this) {
        Transmitter transmitter = $this.transmitter;
        if (transmitter == null) {
            Intrinsics.throwUninitializedPropertyAccessException("transmitter");
        }
        return transmitter;
    }

    public /* synthetic */ RealCall(OkHttpClient client, Request originalRequest, boolean forWebSocket, DefaultConstructorMarker $constructor_marker) {
        this(client, originalRequest, forWebSocket);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u00020\b2\n\u0010\u0012\u001a\u00060\u0000R\u00020\fJ\b\u0010\u0013\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lokhttp3/RealCall$AsyncCall;", "Ljava/lang/Runnable;", "responseCallback", "Lokhttp3/Callback;", "(Lokhttp3/RealCall;Lokhttp3/Callback;)V", "callsPerHost", "Ljava/util/concurrent/atomic/AtomicInteger;", "executeOn", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "get", "Lokhttp3/RealCall;", "host", "", "request", "Lokhttp3/Request;", "reuseCallsPerHostFrom", "other", "run", "okhttp"})
    public final class AsyncCall
    implements Runnable {
        private volatile AtomicInteger callsPerHost;
        private final Callback responseCallback;

        @NotNull
        public final AtomicInteger callsPerHost() {
            return this.callsPerHost;
        }

        public final void reuseCallsPerHostFrom(@NotNull AsyncCall other) {
            Intrinsics.checkParameterIsNotNull(other, "other");
            this.callsPerHost = other.callsPerHost;
        }

        @NotNull
        public final String host() {
            return RealCall.this.getOriginalRequest().url().host();
        }

        @NotNull
        public final Request request() {
            return RealCall.this.getOriginalRequest();
        }

        @NotNull
        public final RealCall get() {
            return RealCall.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void executeOn(@NotNull ExecutorService executorService) {
            Intrinsics.checkParameterIsNotNull(executorService, "executorService");
            Dispatcher $this$assertThreadDoesntHoldLock$iv = RealCall.this.getClient().dispatcher();
            boolean $i$f$assertThreadDoesntHoldLock = false;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                StringBuilder stringBuilder = new StringBuilder().append("Thread ");
                Thread thread2 = Thread.currentThread();
                Intrinsics.checkExpressionValueIsNotNull(thread2, "Thread.currentThread()");
                throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread2.getName()).append(" MUST NOT hold lock on ").append($this$assertThreadDoesntHoldLock$iv).toString()));
            }
            boolean success = false;
            try {
                executorService.execute(this);
                success = true;
            }
            catch (RejectedExecutionException e) {
                InterruptedIOException ioException = new InterruptedIOException("executor rejected");
                ioException.initCause(e);
                RealCall.access$getTransmitter$p(RealCall.this).noMoreExchanges(ioException);
                this.responseCallback.onFailure(RealCall.this, ioException);
            }
            finally {
                RealCall.this.getClient().dispatcher().finished$okhttp(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread currentThread$iv;
            String name$iv = "OkHttp " + RealCall.this.redactedUrl();
            boolean $i$f$threadName = false;
            Thread thread2 = currentThread$iv = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull(thread2, "currentThread");
            String oldName$iv = thread2.getName();
            currentThread$iv.setName(name$iv);
            try {
                boolean bl = false;
                boolean signalledCallback = false;
                RealCall.access$getTransmitter$p(RealCall.this).timeoutEnter();
                try {
                    Response response = RealCall.this.getResponseWithInterceptorChain();
                    signalledCallback = true;
                    this.responseCallback.onResponse(RealCall.this, response);
                }
                catch (IOException e) {
                    if (signalledCallback) {
                        Platform.Companion.get().log("Callback failure for " + RealCall.this.toLoggableString(), 4, e);
                    } else {
                        this.responseCallback.onFailure(RealCall.this, e);
                    }
                }
                catch (Throwable t) {
                    RealCall.this.cancel();
                    if (!signalledCallback) {
                        IOException canceledException = new IOException("canceled due to " + t);
                        canceledException.addSuppressed(t);
                        this.responseCallback.onFailure(RealCall.this, canceledException);
                    }
                    throw t;
                }
                finally {
                    RealCall.this.getClient().dispatcher().finished$okhttp(this);
                }
            }
            finally {
                currentThread$iv.setName(oldName$iv);
            }
        }

        public AsyncCall(Callback responseCallback) {
            Intrinsics.checkParameterIsNotNull(responseCallback, "responseCallback");
            this.responseCallback = responseCallback;
            this.callsPerHost = new AtomicInteger(0);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lokhttp3/RealCall$Companion;", "", "()V", "newRealCall", "Lokhttp3/RealCall;", "client", "Lokhttp3/OkHttpClient;", "originalRequest", "Lokhttp3/Request;", "forWebSocket", "", "okhttp"})
    public static final class Companion {
        @NotNull
        public final RealCall newRealCall(@NotNull OkHttpClient client, @NotNull Request originalRequest, boolean forWebSocket) {
            Intrinsics.checkParameterIsNotNull(client, "client");
            Intrinsics.checkParameterIsNotNull(originalRequest, "originalRequest");
            RealCall realCall = new RealCall(client, originalRequest, forWebSocket, null);
            boolean bl = false;
            boolean bl2 = false;
            RealCall $this$apply = realCall;
            boolean bl3 = false;
            $this$apply.transmitter = new Transmitter(client, $this$apply);
            return realCall;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

