/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.extension.verifier;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.ComponentAware;
import org.apache.camel.catalog.EndpointValidationResult;
import org.apache.camel.catalog.RuntimeCamelCatalog;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.CatalogVerifierCustomizer;
import org.apache.camel.component.extension.verifier.NoSuchOptionException;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.StreamUtils;

public class DefaultComponentVerifierExtension
implements ComponentVerifierExtension,
CamelContextAware,
ComponentAware {
    private final String defaultScheme;
    private Component component;
    private CamelContext camelContext;

    protected DefaultComponentVerifierExtension(String defaultScheme) {
        this(defaultScheme, null, null);
    }

    protected DefaultComponentVerifierExtension(String defaultScheme, CamelContext camelContext) {
        this(defaultScheme, camelContext, null);
    }

    protected DefaultComponentVerifierExtension(String defaultScheme, CamelContext camelContext, Component component) {
        this.defaultScheme = defaultScheme;
        this.camelContext = camelContext;
        this.component = component;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public void setComponent(Component component) {
        this.component = component;
    }

    @Override
    public ComponentVerifierExtension.Result verify(ComponentVerifierExtension.Scope scope2, Map<String, Object> parameters2) {
        if (this.camelContext == null) {
            return ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.ERROR, scope2).error(ResultErrorBuilder.withCodeAndDescription(ComponentVerifierExtension.VerificationError.StandardCode.INTERNAL, "Missing camel-context").build()).build();
        }
        if (scope2 == ComponentVerifierExtension.Scope.PARAMETERS) {
            return this.verifyParameters(parameters2);
        }
        if (scope2 == ComponentVerifierExtension.Scope.CONNECTIVITY) {
            return this.verifyConnectivity(parameters2);
        }
        return ResultBuilder.unsupportedScope(scope2).build();
    }

    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters2) {
        return ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.UNSUPPORTED, ComponentVerifierExtension.Scope.CONNECTIVITY).build();
    }

    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters2) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.OK, ComponentVerifierExtension.Scope.PARAMETERS);
        this.verifyParametersAgainstCatalog(builder, parameters2);
        return builder.build();
    }

    protected void verifyParametersAgainstCatalog(ResultBuilder builder, Map<String, Object> parameters2) {
        this.verifyParametersAgainstCatalog(builder, parameters2, new CatalogVerifierCustomizer());
    }

    protected void verifyParametersAgainstCatalog(ResultBuilder builder, Map<String, Object> parameters2, CatalogVerifierCustomizer customizer2) {
        RuntimeCamelCatalog catalog;
        EndpointValidationResult result2;
        String scheme = this.defaultScheme;
        if (parameters2.containsKey("scheme")) {
            scheme = parameters2.get("scheme").toString();
        }
        if (!(result2 = (catalog = PluginHelper.getRuntimeCamelCatalog(this.camelContext)).validateProperties(scheme, parameters2.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.camelContext.getTypeConverter().convertTo(String.class, e.getValue()))))).isSuccess()) {
            if (customizer2.isIncludeUnknown()) {
                StreamUtils.stream(result2.getUnknown()).map(option -> ResultErrorBuilder.withUnknownOption(option).build()).forEach(builder::error);
            }
            if (customizer2.isIncludeRequired()) {
                StreamUtils.stream(result2.getRequired()).map(option -> ResultErrorBuilder.withMissingOption(option).build()).forEach(builder::error);
            }
            if (customizer2.isIncludeInvalidBoolean()) {
                StreamUtils.stream(result2.getInvalidBoolean()).map(entry -> ResultErrorBuilder.withIllegalOption((String)entry.getKey(), (String)entry.getValue()).build()).forEach(builder::error);
            }
            if (customizer2.isIncludeInvalidInteger()) {
                StreamUtils.stream(result2.getInvalidInteger()).map(entry -> ResultErrorBuilder.withIllegalOption((String)entry.getKey(), (String)entry.getValue()).build()).forEach(builder::error);
            }
            if (customizer2.isIncludeInvalidNumber()) {
                StreamUtils.stream(result2.getInvalidNumber()).map(entry -> ResultErrorBuilder.withIllegalOption((String)entry.getKey(), (String)entry.getValue()).build()).forEach(builder::error);
            }
            if (customizer2.isIncludeInvalidEnum()) {
                StreamUtils.stream(result2.getInvalidEnum()).map(entry -> ResultErrorBuilder.withIllegalOption((String)entry.getKey(), (String)entry.getValue()).detail("enum.values", (Object)result2.getEnumChoices((String)entry.getKey())).build()).forEach(builder::error);
            }
        }
    }

    protected <T> T setProperties(T instance, Map<String, Object> properties2) throws Exception {
        if (this.camelContext == null) {
            throw new IllegalStateException("Camel context is null");
        }
        if (!properties2.isEmpty()) {
            PropertyBindingSupport.build().bind(this.camelContext, instance, properties2);
        }
        return instance;
    }

    protected <T> T setProperties(T instance, String prefix, Map<String, Object> properties2) throws Exception {
        return this.setProperties(instance, PropertiesHelper.extractProperties(properties2, prefix, false));
    }

    protected <T> Optional<T> getOption(Map<String, Object> parameters2, String key, Class<T> type2) {
        Object value = parameters2.get(key);
        if (value != null) {
            return Optional.ofNullable(CamelContextHelper.convertTo(this.camelContext, type2, value));
        }
        return Optional.empty();
    }

    protected <T> T getOption(Map<String, Object> parameters2, String key, Class<T> type2, Supplier<T> defaultSupplier) {
        return this.getOption(parameters2, key, type2).orElseGet(defaultSupplier);
    }

    protected <T> T getMandatoryOption(Map<String, Object> parameters2, String key, Class<T> type2) throws NoSuchOptionException {
        return this.getOption(parameters2, key, type2).orElseThrow(() -> new NoSuchOptionException(key));
    }
}

