/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.saga;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.saga.CamelSagaCoordinator;
import org.apache.camel.saga.CamelSagaStep;
import org.apache.camel.saga.InMemorySagaService;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemorySagaCoordinator
implements CamelSagaCoordinator {
    private static final Logger LOG = LoggerFactory.getLogger(InMemorySagaCoordinator.class);
    private final CamelContext camelContext;
    private final InMemorySagaService sagaService;
    private final String sagaId;
    private final List<CamelSagaStep> steps;
    private final Map<CamelSagaStep, Map<String, Object>> optionValues;
    private final AtomicReference<Status> currentStatus;

    public InMemorySagaCoordinator(CamelContext camelContext, InMemorySagaService sagaService, String sagaId) {
        this.camelContext = ObjectHelper.notNull(camelContext, "camelContext");
        this.sagaService = ObjectHelper.notNull(sagaService, "sagaService");
        this.sagaId = ObjectHelper.notNull(sagaId, "sagaId");
        this.steps = new CopyOnWriteArrayList<CamelSagaStep>();
        this.optionValues = new ConcurrentHashMap<CamelSagaStep, Map<String, Object>>();
        this.currentStatus = new AtomicReference<Status>(Status.RUNNING);
    }

    @Override
    public String getId() {
        return this.sagaId;
    }

    @Override
    public CompletableFuture<Void> beginStep(Exchange exchange, CamelSagaStep step) {
        Status status = this.currentStatus.get();
        if (status != Status.RUNNING) {
            CompletableFuture<Void> res = new CompletableFuture<Void>();
            res.completeExceptionally(new IllegalStateException("Cannot begin: status is " + status));
            return res;
        }
        this.steps.add(step);
        if (!step.getOptions().isEmpty()) {
            this.optionValues.putIfAbsent(step, new ConcurrentHashMap());
            Map values2 = this.optionValues.computeIfAbsent(step, k -> new HashMap());
            for (String option : step.getOptions().keySet()) {
                Expression expression = step.getOptions().get(option);
                if (expression == null) continue;
                try {
                    Object value = expression.evaluate(exchange, Object.class);
                    if (value == null) continue;
                    values2.put(option, value);
                }
                catch (Exception ex) {
                    return CompletableFuture.supplyAsync(() -> {
                        throw new RuntimeCamelException("Cannot evaluate saga option '" + option + "'", ex);
                    });
                }
            }
        }
        if (step.getTimeoutInMilliseconds().isPresent()) {
            this.sagaService.getExecutorService().schedule(() -> {
                boolean doAction = this.currentStatus.compareAndSet(Status.RUNNING, Status.COMPENSATING);
                if (doAction) {
                    this.doCompensate(exchange);
                }
            }, (long)step.getTimeoutInMilliseconds().get(), TimeUnit.MILLISECONDS);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> compensate(Exchange exchange) {
        boolean doAction = this.currentStatus.compareAndSet(Status.RUNNING, Status.COMPENSATING);
        if (doAction) {
            this.doCompensate(exchange);
        } else {
            Status status = this.currentStatus.get();
            if (status != Status.COMPENSATING && status != Status.COMPENSATED) {
                CompletableFuture<Void> res = new CompletableFuture<Void>();
                res.completeExceptionally(new IllegalStateException("Cannot compensate: status is " + status));
                return res;
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> complete(Exchange exchange) {
        boolean doAction = this.currentStatus.compareAndSet(Status.RUNNING, Status.COMPLETING);
        if (doAction) {
            this.doComplete(exchange);
        } else {
            Status status = this.currentStatus.get();
            if (status != Status.COMPLETING && status != Status.COMPLETED) {
                CompletableFuture<Void> res = new CompletableFuture<Void>();
                res.completeExceptionally(new IllegalStateException("Cannot complete: status is " + status));
                return res;
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Boolean> doCompensate(Exchange exchange) {
        return this.doFinalize(exchange, CamelSagaStep::getCompensation, "compensation").thenApply(res -> {
            this.currentStatus.set(Status.COMPENSATED);
            return res;
        });
    }

    public CompletableFuture<Boolean> doComplete(Exchange exchange) {
        return this.doFinalize(exchange, CamelSagaStep::getCompletion, "completion").thenApply(res -> {
            this.currentStatus.set(Status.COMPLETED);
            return res;
        });
    }

    public CompletableFuture<Boolean> doFinalize(Exchange exchange, Function<CamelSagaStep, Optional<Endpoint>> endpointExtractor, String description2) {
        CompletionStage<Boolean> result2 = CompletableFuture.completedFuture(true);
        for (CamelSagaStep step : this.reversed(this.steps)) {
            Optional<Endpoint> endpoint = endpointExtractor.apply(step);
            if (!endpoint.isPresent()) continue;
            result2 = result2.thenCompose(prevResult -> this.doFinalize(exchange, (Endpoint)endpoint.get(), step, 0, description2).thenApply(res -> prevResult != false && res != false));
        }
        return result2.whenComplete((done, ex) -> {
            if (ex != null) {
                LOG.error("Cannot finalize {} the saga", (Object)description2, ex);
            } else if (!done.booleanValue()) {
                LOG.warn("Unable to finalize {} for all required steps of the saga {}", (Object)description2, (Object)this.sagaId);
            }
        });
    }

    private CompletableFuture<Boolean> doFinalize(Exchange exchange, Endpoint endpoint, CamelSagaStep step, int doneAttempts, String description2) {
        Exchange target = this.createExchange(exchange, endpoint, step);
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            Exchange res = this.camelContext.createFluentProducerTemplate().to(endpoint).withExchange(target).send();
            Exception ex = res.getException();
            if (ex != null) {
                throw new RuntimeCamelException(res.getException());
            }
            return true;
        }, this.sagaService.getExecutorService()).exceptionally(ex -> {
            LOG.warn("Exception thrown during {} at {}. Attempt {} of {}", new Object[]{description2, endpoint.getEndpointUri(), doneAttempts + 1, this.sagaService.getMaxRetryAttempts(), ex});
            return false;
        })).thenCompose(executed -> {
            int currentAttempt = doneAttempts + 1;
            if (executed.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            if (currentAttempt >= this.sagaService.getMaxRetryAttempts()) {
                return CompletableFuture.completedFuture(false);
            }
            CompletableFuture future = new CompletableFuture();
            this.sagaService.getExecutorService().schedule(() -> this.doFinalize(target, endpoint, step, currentAttempt, description2).whenComplete((res, ex) -> {
                if (ex != null) {
                    future.completeExceptionally((Throwable)ex);
                } else {
                    future.complete(res);
                }
            }), this.sagaService.getRetryDelayInMilliseconds(), TimeUnit.MILLISECONDS);
            return future;
        });
    }

    private Exchange createExchange(Exchange parent, Endpoint endpoint, CamelSagaStep step) {
        Map<String, Object> values2;
        Object span;
        Exchange answer = endpoint.createExchange();
        answer.getMessage().setHeader("Long-Running-Action", this.getId());
        Object object = span = parent != null ? parent.getProperty(ExchangePropertyKey.ACTIVE_SPAN) : null;
        if (span != null) {
            answer.setProperty(ExchangePropertyKey.ACTIVE_SPAN, span);
        }
        if ((values2 = this.optionValues.get(step)) != null) {
            for (Map.Entry<String, Object> entry : values2.entrySet()) {
                answer.getMessage().setHeader(entry.getKey(), entry.getValue());
            }
        }
        return answer;
    }

    private <T> List<T> reversed(List<T> list) {
        ArrayList<T> reversed = new ArrayList<T>(list);
        Collections.reverse(reversed);
        return reversed;
    }

    private static enum Status {
        RUNNING,
        COMPENSATING,
        COMPENSATED,
        COMPLETING,
        COMPLETED;

    }
}

