/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.SafeCopyProperty;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.spi.VariableRepository;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ExchangeVariableRepository;
import org.apache.camel.support.ExtendedExchangeExtension;
import org.apache.camel.support.MessageSupport;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.trait.message.MessageTrait;
import org.apache.camel.trait.message.RedeliveryTraitPayload;
import org.apache.camel.util.ObjectHelper;

abstract class AbstractExchange
implements Exchange {
    protected final EnumMap<ExchangePropertyKey, Object> internalProperties;
    protected final CamelContext context;
    protected Map<String, Object> properties;
    protected Message in;
    protected Message out;
    protected Exception exception;
    protected String exchangeId;
    protected ExchangePattern pattern;
    protected boolean routeStop;
    protected boolean rollbackOnly;
    protected boolean rollbackOnlyLast;
    protected Map<String, SafeCopyProperty> safeCopyProperties;
    protected ExchangeVariableRepository variableRepository;
    private final ExtendedExchangeExtension privateExtension;
    private RedeliveryTraitPayload externalRedelivered = RedeliveryTraitPayload.UNDEFINED_REDELIVERY;

    protected AbstractExchange(CamelContext context, EnumMap<ExchangePropertyKey, Object> internalProperties, Map<String, Object> properties2) {
        this.context = context;
        this.internalProperties = new EnumMap<ExchangePropertyKey, Object>(internalProperties);
        this.privateExtension = new ExtendedExchangeExtension(this);
        this.properties = AbstractExchange.safeCopyProperties(properties2);
    }

    protected AbstractExchange(CamelContext context) {
        this(context, ExchangePattern.InOnly);
    }

    protected AbstractExchange(CamelContext context, ExchangePattern pattern) {
        this.context = context;
        this.pattern = pattern;
        this.internalProperties = new EnumMap(ExchangePropertyKey.class);
        this.privateExtension = new ExtendedExchangeExtension(this);
    }

    protected AbstractExchange(Exchange parent) {
        this.context = parent.getContext();
        this.pattern = parent.getPattern();
        this.internalProperties = new EnumMap(ExchangePropertyKey.class);
        this.privateExtension = new ExtendedExchangeExtension(this);
        this.privateExtension.setFromEndpoint(parent.getFromEndpoint());
        this.privateExtension.setFromRouteId(parent.getFromRouteId());
        this.privateExtension.setUnitOfWork(parent.getUnitOfWork());
    }

    protected AbstractExchange(AbstractExchange parent) {
        this.context = parent.getContext();
        this.pattern = parent.getPattern();
        this.internalProperties = new EnumMap<ExchangePropertyKey, Object>(parent.internalProperties);
        this.privateExtension = new ExtendedExchangeExtension(this);
        this.privateExtension.setFromEndpoint(parent.getFromEndpoint());
        this.privateExtension.setFromRouteId(parent.getFromRouteId());
        this.privateExtension.setUnitOfWork(parent.getUnitOfWork());
        this.setIn(parent.getIn().copy());
        if (parent.hasOut()) {
            this.setOut(parent.getOut().copy());
        }
        this.setException(parent.exception);
        this.setRouteStop(parent.routeStop);
        this.setRollbackOnly(parent.rollbackOnly);
        this.setRollbackOnlyLast(parent.rollbackOnlyLast);
        this.privateExtension.setNotifyEvent(parent.getExchangeExtension().isNotifyEvent());
        this.privateExtension.setRedeliveryExhausted(parent.getExchangeExtension().isRedeliveryExhausted());
        this.privateExtension.setErrorHandlerHandled(parent.getExchangeExtension().getErrorHandlerHandled());
        this.privateExtension.setStreamCacheDisabled(parent.getExchangeExtension().isStreamCacheDisabled());
        if (parent.hasVariables()) {
            if (this.variableRepository == null) {
                this.variableRepository = new ExchangeVariableRepository(this.getContext());
            }
            this.variableRepository.copyFrom(parent.variableRepository);
        }
        if (parent.hasProperties()) {
            this.properties = AbstractExchange.safeCopyProperties(parent.properties);
        }
        if (parent.hasSafeCopyProperties()) {
            this.safeCopyProperties = parent.copySafeCopyProperties();
        }
    }

    @Override
    public long getCreated() {
        return this.getClock().getCreated();
    }

    abstract AbstractExchange newCopy();

    @Override
    public Exchange copy() {
        AbstractExchange exchange = this.newCopy();
        if (this.getContext().isMessageHistory().booleanValue()) {
            exchange.internalProperties.computeIfPresent(ExchangePropertyKey.MESSAGE_HISTORY, (k, v) -> new CopyOnWriteArrayList((List)v));
        }
        return exchange;
    }

    @Override
    public CamelContext getContext() {
        return this.context;
    }

    @Override
    public Object getProperty(ExchangePropertyKey key) {
        return this.internalProperties.get((Object)key);
    }

    @Override
    public <T> T getProperty(ExchangePropertyKey key, Class<T> type2) {
        Object value = this.getProperty(key);
        return this.evalPropertyValue(type2, value);
    }

    private <T> T evalPropertyValue(Class<T> type2, Object value) {
        if (value == null) {
            if (Boolean.TYPE == type2) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type2.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType(this, type2, value);
    }

    private <T> T evalPropertyValue(Object defaultValue, Class<T> type2, Object value) {
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            if (Boolean.TYPE == type2) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type2.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType(this, type2, value);
    }

    @Override
    public <T> T getProperty(ExchangePropertyKey key, Object defaultValue, Class<T> type2) {
        Object value = this.getProperty(key);
        return this.evalPropertyValue(defaultValue, type2, value);
    }

    @Override
    public void setProperty(ExchangePropertyKey key, Object value) {
        this.internalProperties.put(key, value);
    }

    @Override
    public Object removeProperty(ExchangePropertyKey key) {
        return this.internalProperties.remove((Object)key);
    }

    @Override
    public Object getProperty(String name) {
        Object answer = null;
        ExchangePropertyKey key = ExchangePropertyKey.asExchangePropertyKey(name);
        if (key != null) {
            answer = this.internalProperties.get((Object)key);
        }
        if (answer == null && this.properties != null) {
            answer = this.properties.get(name);
        }
        return answer;
    }

    @Override
    public <T> T getProperty(String name, Class<T> type2) {
        Object value = this.getProperty(name);
        return this.evalPropertyValue(type2, value);
    }

    @Override
    public <T> T getProperty(String name, Object defaultValue, Class<T> type2) {
        Object value = this.getProperty(name);
        return this.evalPropertyValue(defaultValue, type2, value);
    }

    @Override
    public void setProperty(String name, Object value) {
        ExchangePropertyKey key = ExchangePropertyKey.asExchangePropertyKey(name);
        if (key != null) {
            this.setProperty(key, value);
        } else if (value != null) {
            if (this.properties == null) {
                this.properties = new ConcurrentHashMap<String, Object>(8);
            }
            this.properties.put(name, value);
        } else if (this.properties != null) {
            this.properties.remove(name);
        }
    }

    void setProperties(Map<String, Object> properties2) {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, Object>(8);
        } else {
            this.properties.clear();
        }
        this.properties.putAll(properties2);
    }

    @Override
    public Object removeProperty(String name) {
        ExchangePropertyKey key = ExchangePropertyKey.asExchangePropertyKey(name);
        if (key != null) {
            return this.removeProperty(key);
        }
        if (!this.hasProperties()) {
            return null;
        }
        return this.properties.remove(name);
    }

    @Override
    public boolean removeProperties(String pattern) {
        return this.removeProperties(pattern, null);
    }

    @Override
    public boolean removeProperties(String pattern, String ... excludePatterns) {
        Set<String> toBeRemoved;
        if (excludePatterns == null && "*".equals(pattern)) {
            if (this.properties != null) {
                this.properties.clear();
            }
            this.internalProperties.clear();
            return true;
        }
        boolean matches = false;
        for (ExchangePropertyKey epk : ExchangePropertyKey.values()) {
            String key = epk.getName();
            if (!PatternHelper.matchPattern(key, pattern) || excludePatterns != null && PatternHelper.isExcludePatternMatch(key, excludePatterns)) continue;
            matches = true;
            this.internalProperties.remove((Object)epk);
        }
        if (this.properties != null && (toBeRemoved = PatternHelper.matchingSet(this.properties, pattern, excludePatterns)) != null) {
            matches = true;
            if (toBeRemoved.size() == this.properties.size()) {
                this.properties.clear();
            } else {
                for (String key : toBeRemoved) {
                    this.properties.remove(key);
                }
            }
        }
        return matches;
    }

    @Override
    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, Object>(8);
        }
        return this.properties;
    }

    private Map<String, SafeCopyProperty> copySafeCopyProperties() {
        ConcurrentHashMap<String, SafeCopyProperty> copy2 = new ConcurrentHashMap<String, SafeCopyProperty>();
        for (Map.Entry<String, SafeCopyProperty> entry : this.safeCopyProperties.entrySet()) {
            copy2.put(entry.getKey(), entry.getValue().safeCopy());
        }
        return copy2;
    }

    @Override
    public Map<String, Object> getAllProperties() {
        Map<String, Object> map = this.getInternalProperties();
        if (this.properties != null && !this.properties.isEmpty()) {
            map.putAll(this.properties);
        }
        return map;
    }

    @Override
    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    private boolean hasSafeCopyProperties() {
        return this.safeCopyProperties != null && !this.safeCopyProperties.isEmpty();
    }

    @Override
    public Object getVariable(String name) {
        VariableRepository repo = null;
        String id = ExchangeHelper.getVariableRepositoryId(name);
        if (id != null) {
            repo = ExchangeHelper.getVariableRepository(this, id);
            name = ExchangeHelper.resolveVariableRepositoryName(this, name, id);
        }
        if (repo != null && name != null) {
            return repo.getVariable(name);
        }
        if (this.variableRepository != null) {
            return this.variableRepository.getVariable(name);
        }
        return null;
    }

    @Override
    public <T> T getVariable(String name, Class<T> type2) {
        Object value = this.getVariable(name);
        return this.evalPropertyValue(type2, value);
    }

    @Override
    public <T> T getVariable(String name, Object defaultValue, Class<T> type2) {
        Object value = this.getVariable(name);
        return this.evalPropertyValue(defaultValue, type2, value);
    }

    @Override
    public void setVariable(String name, Object value) {
        VariableRepository repo = null;
        String id = ExchangeHelper.getVariableRepositoryId(name);
        if (id != null) {
            repo = ExchangeHelper.getVariableRepository(this, id);
            name = ExchangeHelper.resolveVariableRepositoryName(this, name, id);
        }
        if (repo != null) {
            repo.setVariable(name, value);
        } else {
            if (this.variableRepository == null) {
                this.variableRepository = new ExchangeVariableRepository(this.getContext());
            }
            this.variableRepository.setVariable(name, value);
        }
    }

    @Override
    public Object removeVariable(String name) {
        VariableRepository repo = null;
        String id = ExchangeHelper.getVariableRepositoryId(name);
        if (id != null) {
            repo = ExchangeHelper.getVariableRepository(this, id);
            name = ExchangeHelper.resolveVariableRepositoryName(this, name, id);
        }
        if (repo != null) {
            return repo.removeVariable(name);
        }
        if (this.variableRepository != null) {
            if ("*".equals(name)) {
                this.variableRepository.clear();
                return null;
            }
            return this.variableRepository.removeVariable(name);
        }
        return null;
    }

    @Override
    public Map<String, Object> getVariables() {
        if (this.variableRepository == null) {
            this.variableRepository = new ExchangeVariableRepository(this.getContext());
        }
        return this.variableRepository.getVariables();
    }

    @Override
    public boolean hasVariables() {
        if (this.variableRepository != null) {
            return this.variableRepository.hasVariables();
        }
        return false;
    }

    @Override
    public Message getIn() {
        if (this.in == null) {
            this.in = new DefaultMessage(this.getContext());
            this.configureMessage(this.in);
        }
        return this.in;
    }

    @Override
    public <T> T getIn(Class<T> type2) {
        Message in = this.getIn();
        if (type2.isInstance(in)) {
            return type2.cast(in);
        }
        return this.context.getTypeConverter().convertTo(type2, this, in);
    }

    <T> T getInOrNull(Class<T> type2) {
        if (this.in == null) {
            return null;
        }
        if (type2.isInstance(this.in)) {
            return type2.cast(this.in);
        }
        return null;
    }

    @Override
    public void setIn(Message in) {
        this.in = in;
        this.configureMessage(in);
    }

    @Override
    public Message getOut() {
        if (this.out == null) {
            this.out = this.newOutMessage();
            this.configureMessage(this.out);
        }
        return this.out;
    }

    private Message newOutMessage() {
        Message message = this.in;
        if (message instanceof MessageSupport) {
            MessageSupport messageSupport = (MessageSupport)message;
            return messageSupport.newInstance();
        }
        return new DefaultMessage(this.getContext());
    }

    @Override
    public <T> T getOut(Class<T> type2) {
        if (!this.hasOut()) {
            return null;
        }
        Message out = this.getOut();
        if (type2.isInstance(out)) {
            return type2.cast(out);
        }
        return this.context.getTypeConverter().convertTo(type2, this, out);
    }

    @Override
    public boolean hasOut() {
        return this.out != null;
    }

    @Override
    public void setOut(Message out) {
        this.out = out;
        this.configureMessage(out);
    }

    @Override
    public Message getMessage() {
        return this.hasOut() ? this.getOut() : this.getIn();
    }

    @Override
    public <T> T getMessage(Class<T> type2) {
        return this.hasOut() ? this.getOut(type2) : this.getIn(type2);
    }

    @Override
    public void setMessage(Message message) {
        if (this.hasOut()) {
            this.setOut(message);
        } else {
            this.setIn(message);
        }
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public <T> T getException(Class<T> type2) {
        return ObjectHelper.getException(type2, this.exception);
    }

    @Override
    public void setException(Throwable t) {
        Exception exception;
        this.exception = t == null ? null : (t instanceof Exception ? (exception = (Exception)t) : CamelExecutionException.wrapCamelExecutionException(this, t));
        if (t instanceof InterruptedException) {
            this.privateExtension.setInterrupted(true);
        }
    }

    @Override
    public ExchangePattern getPattern() {
        return this.pattern;
    }

    @Override
    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public Endpoint getFromEndpoint() {
        return this.privateExtension.getFromEndpoint();
    }

    @Override
    public String getFromRouteId() {
        return this.privateExtension.getFromRouteId();
    }

    @Override
    public String getExchangeId() {
        if (this.exchangeId == null) {
            this.exchangeId = this.createExchangeId();
        }
        return this.exchangeId;
    }

    @Override
    public void setExchangeId(String id) {
        this.exchangeId = id;
    }

    @Override
    public boolean isFailed() {
        return this.exception != null;
    }

    @Override
    public boolean isTransacted() {
        return this.privateExtension.isTransacted();
    }

    @Override
    public boolean isRouteStop() {
        return this.routeStop;
    }

    @Override
    public void setRouteStop(boolean routeStop) {
        this.routeStop = routeStop;
    }

    @Override
    public boolean isExternalRedelivered() {
        if (this.externalRedelivered == RedeliveryTraitPayload.UNDEFINED_REDELIVERY) {
            Message message = this.getIn();
            this.externalRedelivered = (RedeliveryTraitPayload)((Object)message.getPayloadForTrait(MessageTrait.REDELIVERY));
        }
        return this.externalRedelivered == RedeliveryTraitPayload.IS_REDELIVERY;
    }

    @Override
    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    @Override
    public void setRollbackOnly(boolean rollbackOnly) {
        this.rollbackOnly = rollbackOnly;
    }

    @Override
    public boolean isRollbackOnlyLast() {
        return this.rollbackOnlyLast;
    }

    @Override
    public void setRollbackOnlyLast(boolean rollbackOnlyLast) {
        this.rollbackOnlyLast = rollbackOnlyLast;
    }

    @Override
    public UnitOfWork getUnitOfWork() {
        return this.privateExtension.getUnitOfWork();
    }

    protected void configureMessage(Message message) {
        if (message instanceof MessageSupport) {
            MessageSupport messageSupport = (MessageSupport)message;
            messageSupport.setExchange(this);
            messageSupport.setCamelContext(this.getContext());
        }
    }

    void copyInternalProperties(Exchange target) {
        ((AbstractExchange)target).internalProperties.putAll(this.internalProperties);
    }

    Map<String, Object> getInternalProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ExchangePropertyKey key : ExchangePropertyKey.values()) {
            Object value = this.internalProperties.get((Object)key);
            if (value == null) continue;
            map.put(key.getName(), value);
        }
        return map;
    }

    protected String createExchangeId() {
        return this.context.getUuidGenerator().generateExchangeUuid();
    }

    public final String toString() {
        if (this.exchangeId != null) {
            return "Exchange[" + this.exchangeId + "]";
        }
        return "Exchange[]";
    }

    void setSafeCopyProperty(String key, SafeCopyProperty value) {
        if (value != null) {
            if (this.safeCopyProperties == null) {
                this.safeCopyProperties = new ConcurrentHashMap<String, SafeCopyProperty>(2);
            }
            this.safeCopyProperties.put(key, value);
        } else if (this.safeCopyProperties != null) {
            this.safeCopyProperties.remove(key);
        }
    }

    <T> T getSafeCopyProperty(String key, Class<T> type2) {
        if (!this.hasSafeCopyProperties()) {
            return null;
        }
        SafeCopyProperty value = this.safeCopyProperties.get(key);
        if (type2.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType(this, type2, value);
    }

    @Override
    public ExtendedExchangeExtension getExchangeExtension() {
        return this.privateExtension;
    }

    private static Map<String, Object> safeCopyProperties(Map<String, Object> properties2) {
        if (properties2 == null) {
            return null;
        }
        return new ConcurrentHashMap<String, Object>(properties2);
    }
}

