/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.TimeoutMap;
import org.apache.camel.support.NoLock;
import org.apache.camel.support.TimeoutMapEntry;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTimeoutMap<K, V>
extends ServiceSupport
implements TimeoutMap<K, V> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<K, TimeoutMapEntry<K, V>> map = new ConcurrentHashMap<K, TimeoutMapEntry<K, V>>();
    private final ScheduledExecutorService executor;
    private volatile ScheduledFuture<?> future;
    private final long purgePollTime;
    private final Lock lock;
    private final List<TimeoutMap.Listener<K, V>> listeners = new ArrayList<TimeoutMap.Listener<K, V>>(2);

    public DefaultTimeoutMap(ScheduledExecutorService executor) {
        this(executor, 1000L);
    }

    public DefaultTimeoutMap(ScheduledExecutorService executor, long requestMapPollTimeMillis) {
        this(executor, requestMapPollTimeMillis, true);
    }

    public DefaultTimeoutMap(ScheduledExecutorService executor, long requestMapPollTimeMillis, boolean useLock) {
        this(executor, requestMapPollTimeMillis, useLock ? new ReentrantLock() : NoLock.INSTANCE);
    }

    public DefaultTimeoutMap(ScheduledExecutorService executor, long requestMapPollTimeMillis, Lock lock) {
        ObjectHelper.notNull(executor, "ScheduledExecutorService");
        this.executor = executor;
        this.purgePollTime = requestMapPollTimeMillis;
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        TimeoutMapEntry entry;
        if (!this.map.containsKey(key)) {
            return null;
        }
        this.lock.lock();
        try {
            entry = (TimeoutMapEntry)this.map.get(key);
            if (entry == null) {
                V v = null;
                return v;
            }
            this.updateExpireTime(entry);
        }
        finally {
            this.lock.unlock();
        }
        return entry.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value, long timeoutMillis) {
        TimeoutMapEntry<K, V> entry = new TimeoutMapEntry<K, V>(key, value, timeoutMillis);
        this.lock.lock();
        try {
            this.updateExpireTime(entry);
            TimeoutMapEntry<K, V> result2 = this.map.put(key, entry);
            V v = DefaultTimeoutMap.unwrap(result2);
            return v;
        }
        finally {
            this.lock.unlock();
            this.emitEvent(TimeoutMap.Listener.Type.Put, key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value, long timeoutMillis) {
        TimeoutMapEntry<K, V> entry = new TimeoutMapEntry<K, V>(key, value, timeoutMillis);
        TimeoutMapEntry<K, V> result2 = null;
        this.lock.lock();
        try {
            this.updateExpireTime(entry);
            result2 = this.map.putIfAbsent(key, entry);
            V v = DefaultTimeoutMap.unwrap(result2);
            return v;
        }
        finally {
            this.lock.unlock();
            if (result2 != entry) {
                this.emitEvent(TimeoutMap.Listener.Type.Put, key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        if (!this.map.containsKey(key)) {
            return null;
        }
        V value = null;
        this.lock.lock();
        try {
            V v = value = (V)DefaultTimeoutMap.unwrap((TimeoutMapEntry)this.map.remove(key));
            return v;
        }
        finally {
            this.lock.unlock();
            if (value != null) {
                this.emitEvent(TimeoutMap.Listener.Type.Remove, key, value);
            }
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    private void purgeTask() {
        if (!this.isRunAllowed()) {
            this.log.trace("Purge task not allowed to run");
            return;
        }
        this.log.trace("Running purge task to see if any entries have been timed out");
        try {
            this.purge();
        }
        catch (Exception t) {
            this.log.warn("Exception occurred during purge task. This exception will be ignored.", (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purge() {
        this.log.trace("There are {} in the timeout map", (Object)this.map.size());
        if (this.map.isEmpty()) {
            return;
        }
        long now = this.currentTime();
        ArrayList<TimeoutMapEntry> expired = new ArrayList<TimeoutMapEntry>(this.map.size());
        this.lock.lock();
        try {
            for (Map.Entry entry : this.map.entrySet()) {
                if (((TimeoutMapEntry)entry.getValue()).getExpireTime() >= now || !this.isValidForEviction((TimeoutMapEntry)entry.getValue())) continue;
                this.log.debug("Evicting inactive entry ID: {}", entry.getValue());
                expired.add((TimeoutMapEntry)entry.getValue());
            }
            if (!expired.isEmpty()) {
                expired.sort(Comparator.comparing(TimeoutMapEntry::getExpireTime));
                for (TimeoutMapEntry timeoutMapEntry : expired) {
                    this.map.remove(timeoutMapEntry.getKey());
                }
            }
        }
        finally {
            this.lock.unlock();
            for (TimeoutMapEntry timeoutMapEntry : expired) {
                this.emitEvent(TimeoutMap.Listener.Type.Evict, timeoutMapEntry.getKey(), timeoutMapEntry.getValue());
            }
        }
    }

    public long getPurgePollTime() {
        return this.purgePollTime;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    private static <K, V> V unwrap(TimeoutMapEntry<K, V> entry) {
        return entry == null ? null : (V)entry.getValue();
    }

    @Override
    public void addListener(TimeoutMap.Listener<K, V> listener) {
        this.listeners.add(listener);
    }

    private void emitEvent(TimeoutMap.Listener.Type type2, K key, V value) {
        for (TimeoutMap.Listener<K, V> listener : this.listeners) {
            try {
                listener.timeoutMapEvent(type2, key, value);
            }
            catch (Exception exception) {}
        }
    }

    protected void schedulePoll() {
        this.future = this.executor.scheduleWithFixedDelay(this::purgeTask, 0L, this.purgePollTime, TimeUnit.MILLISECONDS);
    }

    protected boolean isValidForEviction(TimeoutMapEntry<K, V> entry) {
        return true;
    }

    protected void updateExpireTime(TimeoutMapEntry<K, V> entry) {
        long now = this.currentTime();
        entry.setExpireTime(entry.getTimeout() + now);
    }

    protected long currentTime() {
        return System.currentTimeMillis();
    }

    @Override
    protected void doStart() throws Exception {
        if (this.executor.isShutdown()) {
            throw new IllegalStateException("The ScheduledExecutorService is shutdown");
        }
        this.schedulePoll();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
        this.map.clear();
    }
}

