/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.function.Supplier;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.spi.InvokeOnHeaderStrategy;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HeaderSelectorProducer
extends DefaultAsyncProducer
implements CamelContextAware {
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/invoke-on-header/";
    private static final Logger LOGGER = LoggerFactory.getLogger(HeaderSelectorProducer.class);
    private final Supplier<String> headerSupplier;
    private final Supplier<String> defaultHeaderValueSupplier;
    private final Object target;
    private CamelContext camelContext;
    private InvokeOnHeaderStrategy strategy;
    private InvokeOnHeaderStrategy parentStrategy;

    public HeaderSelectorProducer(Endpoint endpoint, Supplier<String> headerSupplier) {
        this(endpoint, headerSupplier, () -> null, null);
    }

    public HeaderSelectorProducer(Endpoint endpoint, String header) {
        this(endpoint, () -> header, () -> null, null);
    }

    public HeaderSelectorProducer(Endpoint endpoint, String header, Object target) {
        this(endpoint, () -> header, () -> null, target);
    }

    public HeaderSelectorProducer(Endpoint endpoint, Supplier<String> headerSupplier, Object target) {
        this(endpoint, headerSupplier, () -> null, target);
    }

    public HeaderSelectorProducer(Endpoint endpoint, String header, String defaultHeaderValue) {
        this(endpoint, () -> header, () -> defaultHeaderValue, null);
    }

    public HeaderSelectorProducer(Endpoint endpoint, String header, Supplier<String> defaultHeaderValueSupplier) {
        this(endpoint, () -> header, defaultHeaderValueSupplier, null);
    }

    public HeaderSelectorProducer(Endpoint endpoint, Supplier<String> headerSupplier, Supplier<String> defaultHeaderValueSupplier) {
        this(endpoint, headerSupplier, defaultHeaderValueSupplier, null);
    }

    public HeaderSelectorProducer(Endpoint endpoint, String header, String defaultHeaderValue, Object target) {
        this(endpoint, () -> header, () -> defaultHeaderValue, target);
    }

    public HeaderSelectorProducer(Endpoint endpoint, Supplier<String> headerSupplier, Supplier<String> defaultHeaderValueSupplier, Object target) {
        super(endpoint);
        this.headerSupplier = ObjectHelper.notNull(headerSupplier, "headerSupplier");
        this.defaultHeaderValueSupplier = ObjectHelper.notNull(defaultHeaderValueSupplier, "defaultHeaderValueSupplier");
        this.target = target != null ? target : this;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    protected void doBuild() throws Exception {
        super.doBuild();
        String key = this.getClass().getName();
        String fqn = RESOURCE_PATH + key;
        this.strategy = this.camelContext.getCamelContextExtension().getBootstrapFactoryFinder(RESOURCE_PATH).newInstance(key, InvokeOnHeaderStrategy.class).orElseThrow(() -> new IllegalArgumentException("Cannot find " + fqn + " in classpath."));
        Class<?> sclazz = this.getClass().getSuperclass();
        if (sclazz != null && !sclazz.getName().equals("java.lang.Object") && !sclazz.getName().equals(HeaderSelectorProducer.class.getName())) {
            String key2 = this.getClass().getSuperclass().getName();
            this.parentStrategy = this.camelContext.getCamelContextExtension().getBootstrapFactoryFinder(RESOURCE_PATH).newInstance(key2, InvokeOnHeaderStrategy.class).orElse(null);
        }
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        boolean sync = true;
        try {
            String header = this.headerSupplier.get();
            String action = exchange.getIn().getHeader(header, String.class);
            if (action == null) {
                action = this.defaultHeaderValueSupplier.get();
            }
            if (action == null) {
                throw new NoSuchHeaderException(exchange, header, String.class);
            }
            LOGGER.debug("Invoking @InvokeOnHeader method: {}", (Object)action);
            Object answer = this.strategy.invoke(this.target, action, exchange, callback);
            if (answer == null && this.parentStrategy != null) {
                answer = this.parentStrategy.invoke(this.target, action, exchange, callback);
            }
            if (answer == callback) {
                sync = false;
                answer = null;
            }
            if (sync) {
                LOGGER.trace("Invoked @InvokeOnHeader method: {} -> {}", (Object)action, answer);
                this.processResult(exchange, answer);
            } else {
                LOGGER.trace("Invoked @InvokeOnHeader method: {} is continuing asynchronously", (Object)action);
            }
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        if (sync) {
            callback.done(true);
        }
        return sync;
    }

    protected void processResult(Exchange exchange, Object result2) {
        if (result2 != null) {
            exchange.getMessage().setBody(result2);
        }
    }
}

