/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.SupplierRegistry;

public final class LocalBeanRegistry
extends SupplierRegistry {
    private final Map<String, String> destroyMethods = new HashMap<String, String>();

    public void registerDestroyMethod(String id, String method) {
        this.destroyMethods.put(id, method);
    }

    public LocalBeanRegistry copy() {
        LocalBeanRegistry copy2 = new LocalBeanRegistry();
        copy2.putAll(this);
        return copy2;
    }

    public Set<String> keys() {
        return Collections.unmodifiableSet(this.keySet());
    }

    @Override
    public void close() throws IOException {
        this.destroyMethods.forEach((id, method) -> {
            Object bean = this.lookupByName((String)id);
            if (bean != null) {
                try {
                    ObjectHelper.invokeMethodSafe(method, bean, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.destroyMethods.clear();
        super.close();
    }
}

