/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Registry;

public class SimpleRegistry
extends LinkedHashMap<String, Map<Class<?>, Object>>
implements Registry,
Closeable {
    @Override
    public Object lookupByName(String name) {
        return this.lookupByNameAndType(name, Object.class);
    }

    @Override
    public <T> T lookupByNameAndType(String name, Class<T> type2) {
        Map map = (Map)this.get(name);
        if (map == null) {
            return null;
        }
        Object answer = map.get(type2);
        if (answer == null) {
            for (Object value : map.values()) {
                if (!type2.isInstance(value)) continue;
                answer = value;
                break;
            }
        }
        if (answer == null) {
            return null;
        }
        try {
            answer = this.unwrap(answer);
            return type2.cast(answer);
        }
        catch (Exception e) {
            String msg = "Found bean: " + name + " in SimpleRegistry: " + this + " of type: " + answer.getClass().getName() + " expected type was: " + type2;
            throw new NoSuchBeanException(name, msg, e);
        }
    }

    @Override
    public <T> Map<String, T> findByTypeWithName(Class<T> type2) {
        LinkedHashMap<String, T> result2 = new LinkedHashMap<String, T>();
        for (Map.Entry entry : this.entrySet()) {
            for (Object value : ((Map)entry.getValue()).values()) {
                if (!type2.isInstance(value)) continue;
                value = this.unwrap(value);
                result2.put((String)entry.getKey(), type2.cast(value));
            }
        }
        return result2;
    }

    @Override
    public <T> Set<T> findByType(Class<T> type2) {
        LinkedHashSet<T> result2 = new LinkedHashSet<T>();
        for (Map.Entry entry : this.entrySet()) {
            for (Object value : ((Map)entry.getValue()).values()) {
                if (!type2.isInstance(value)) continue;
                value = this.unwrap(value);
                result2.add(type2.cast(value));
            }
        }
        return result2;
    }

    @Override
    public void bind(String id, Class<?> type2, Object bean) {
        if (bean != null) {
            this.computeIfAbsent(id, k -> new LinkedHashMap()).put(type2, this.wrap(bean));
        }
    }

    @Override
    public void bind(String id, Class<?> type2, Object bean, String initMethod, String destroyMethod) throws RuntimeCamelException {
        throw new UnsupportedOperationException("Use DefaultRegistry");
    }

    @Override
    public void bind(String id, Class<?> type2, Supplier<Object> bean) {
        throw new UnsupportedOperationException("Use SupplierRegistry");
    }

    @Override
    public void bindAsPrototype(String id, Class<?> type2, Supplier<Object> bean) {
        throw new UnsupportedOperationException("Use SupplierRegistry");
    }

    @Override
    public void unbind(String id) {
        this.remove(id);
    }

    @Override
    public void close() throws IOException {
        this.clear();
    }
}

