/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;

public abstract class TypeConverterSupport
implements TypeConverter {
    @Override
    public boolean allowNull() {
        return false;
    }

    @Override
    public <T> T convertTo(Class<T> type2, Object value) throws TypeConversionException {
        return this.convertTo(type2, null, value);
    }

    @Override
    public <T> T mandatoryConvertTo(Class<T> type2, Object value) throws TypeConversionException, NoTypeConversionAvailableException {
        T t = this.convertTo(type2, null, value);
        if (t == null) {
            throw new NoTypeConversionAvailableException(value, type2);
        }
        return t;
    }

    @Override
    public <T> T mandatoryConvertTo(Class<T> type2, Exchange exchange, Object value) throws TypeConversionException, NoTypeConversionAvailableException {
        T t = this.convertTo(type2, exchange, value);
        if (t == null) {
            throw new NoTypeConversionAvailableException(value, type2);
        }
        return t;
    }

    @Override
    public <T> T tryConvertTo(Class<T> type2, Object value) {
        try {
            return this.convertTo(type2, null, value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public <T> T tryConvertTo(Class<T> type2, Exchange exchange, Object value) {
        try {
            return this.convertTo(type2, exchange, value);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

