/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.web3j.abi.TypeMappingException;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Fixed;
import org.web3j.abi.datatypes.Int;
import org.web3j.abi.datatypes.StaticArray;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Ufixed;
import org.web3j.abi.datatypes.Uint;
import org.web3j.abi.datatypes.Utf8String;

public class Utils {
    private Utils() {
    }

    static <T extends Type> String getTypeName(TypeReference<T> typeReference) {
        try {
            java.lang.reflect.Type reflectedType = typeReference.getType();
            if (reflectedType instanceof ParameterizedType) {
                Class type2 = (Class)((ParameterizedType)reflectedType).getRawType();
                return Utils.getParameterizedTypeName(typeReference, type2);
            }
            Class<?> type3 = Class.forName(reflectedType.getTypeName());
            return Utils.getSimpleTypeName(type3);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    static String getSimpleTypeName(Class<?> type2) {
        String simpleName2 = type2.getSimpleName().toLowerCase();
        if (type2.equals(Uint.class) || type2.equals(Int.class) || type2.equals(Ufixed.class) || type2.equals(Fixed.class)) {
            return simpleName2 + "256";
        }
        if (type2.equals(Utf8String.class)) {
            return "string";
        }
        if (type2.equals(DynamicBytes.class)) {
            return "bytes";
        }
        return simpleName2;
    }

    static <T extends Type, U extends Type> String getParameterizedTypeName(TypeReference<T> typeReference, Class<?> type2) {
        try {
            if (type2.equals(DynamicArray.class)) {
                Class<T> parameterizedType = Utils.getParameterizedTypeFromArray(typeReference);
                String parameterizedTypeName = Utils.getSimpleTypeName(parameterizedType);
                return parameterizedTypeName + "[]";
            }
            if (type2.equals(StaticArray.class)) {
                Class<T> parameterizedType = Utils.getParameterizedTypeFromArray(typeReference);
                String parameterizedTypeName = Utils.getSimpleTypeName(parameterizedType);
                return parameterizedTypeName + "[" + ((TypeReference.StaticArrayTypeReference)typeReference).getSize() + "]";
            }
            throw new UnsupportedOperationException("Invalid type provided " + type2.getName());
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    static <T extends Type> Class<T> getParameterizedTypeFromArray(TypeReference typeReference) throws ClassNotFoundException {
        java.lang.reflect.Type type2 = typeReference.getType();
        java.lang.reflect.Type[] typeArguments = ((ParameterizedType)type2).getActualTypeArguments();
        String parameterizedTypeName = typeArguments[0].getTypeName();
        return Class.forName(parameterizedTypeName);
    }

    public static List<TypeReference<Type>> convert(List<TypeReference<?>> input) {
        ArrayList<TypeReference<Type>> result2 = new ArrayList<TypeReference<Type>>(input.size());
        result2.addAll(input.stream().map(typeReference -> typeReference).collect(Collectors.toList()));
        return result2;
    }

    public static <T, R extends Type<T>, E extends Type<T>> List<E> typeMap(List<List<T>> input, Class<E> outerDestType, Class<R> innerType) {
        ArrayList<Type> result2 = new ArrayList<Type>();
        try {
            Constructor<E> constructor = outerDestType.getDeclaredConstructor(Class.class, List.class);
            for (List<T> ts : input) {
                Type e = (Type)constructor.newInstance(innerType, Utils.typeMap(ts, innerType));
                result2.add(e);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TypeMappingException(e);
        }
        return result2;
    }

    public static <T, R extends Type<T>> List<R> typeMap(List<T> input, Class<R> destType) throws TypeMappingException {
        ArrayList<R> result2 = new ArrayList<R>(input.size());
        if (!input.isEmpty()) {
            try {
                Constructor<R> constructor = destType.getDeclaredConstructor(input.get(0).getClass());
                for (T value : input) {
                    result2.add(constructor.newInstance(value));
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new TypeMappingException(e);
            }
        }
        return result2;
    }
}

