/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.math.BigInteger;
import org.web3j.utils.Numeric;

public class RawTransaction {
    private BigInteger nonce;
    private BigInteger gasPrice;
    private BigInteger gasLimit;
    private String to;
    private BigInteger value;
    private String data;
    private BigInteger gasPremium;
    private BigInteger feeCap;

    protected RawTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data2) {
        this(nonce, gasPrice, gasLimit, to, value, data2, null, null);
    }

    protected RawTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data2, BigInteger gasPremium, BigInteger feeCap) {
        this.nonce = nonce;
        this.gasPrice = gasPrice;
        this.gasLimit = gasLimit;
        this.to = to;
        this.value = value;
        this.data = data2 != null ? Numeric.cleanHexPrefix(data2) : null;
        this.gasPremium = gasPremium;
        this.feeCap = feeCap;
    }

    public static RawTransaction createContractTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, BigInteger value, String init) {
        return new RawTransaction(nonce, gasPrice, gasLimit, "", value, init);
    }

    public static RawTransaction createEtherTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value) {
        return new RawTransaction(nonce, gasPrice, gasLimit, to, value, "");
    }

    public static RawTransaction createEtherTransaction(BigInteger nonce, BigInteger gasLimit, String to, BigInteger value, BigInteger gasPremium, BigInteger feeCap) {
        return new RawTransaction(nonce, null, gasLimit, to, value, "", gasPremium, feeCap);
    }

    public static RawTransaction createTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, String data2) {
        return RawTransaction.createTransaction(nonce, gasPrice, gasLimit, to, BigInteger.ZERO, data2);
    }

    public static RawTransaction createTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data2) {
        return new RawTransaction(nonce, gasPrice, gasLimit, to, value, data2);
    }

    public static RawTransaction createTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data2, BigInteger gasPremium, BigInteger feeCap) {
        return new RawTransaction(nonce, gasPrice, gasLimit, to, value, data2, gasPremium, feeCap);
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public BigInteger getGasPrice() {
        return this.gasPrice;
    }

    public BigInteger getGasLimit() {
        return this.gasLimit;
    }

    public String getTo() {
        return this.to;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public String getData() {
        return this.data;
    }

    public BigInteger getGasPremium() {
        return this.gasPremium;
    }

    public BigInteger getFeeCap() {
        return this.feeCap;
    }

    public boolean isLegacyTransaction() {
        return this.gasPrice != null && this.gasPremium == null && this.feeCap == null;
    }

    public boolean isEIP1559Transaction() {
        return this.gasPrice == null && this.gasPremium != null && this.feeCap != null;
    }
}

