/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.web3j.abi.TypeEncoder;
import org.web3j.abi.datatypes.AbiTypes;
import org.web3j.abi.datatypes.Type;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Pair;
import org.web3j.crypto.StructuredData;
import org.web3j.utils.Numeric;

public class StructuredDataEncoder {
    public final StructuredData.EIP712Message jsonMessageObject;
    final String arrayTypeRegex = "^([a-zA-Z_$][a-zA-Z_$0-9]*)((\\[([1-9]\\d*)?\\])+)$";
    final Pattern arrayTypePattern = Pattern.compile("^([a-zA-Z_$][a-zA-Z_$0-9]*)((\\[([1-9]\\d*)?\\])+)$");
    final String bytesTypeRegex = "^bytes[0-9][0-9]?$";
    final Pattern bytesTypePattern = Pattern.compile("^bytes[0-9][0-9]?$");
    final String arrayDimensionRegex = "\\[([1-9]\\d*)?\\]";
    final Pattern arrayDimensionPattern = Pattern.compile("\\[([1-9]\\d*)?\\]");
    final String typeRegex = "^[a-zA-Z_$][a-zA-Z_$0-9]*(\\[([1-9]\\d*)*\\])*$";
    final Pattern typePattern = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*(\\[([1-9]\\d*)*\\])*$");
    final String identifierRegex = "^[a-zA-Z_$][a-zA-Z_$0-9]*$";
    final Pattern identifierPattern = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*$");

    public StructuredDataEncoder(String jsonMessageInString) throws IOException, RuntimeException {
        this.jsonMessageObject = this.parseJSONMessage(jsonMessageInString);
    }

    public Set<String> getDependencies(String primaryType) {
        HashMap<String, List<StructuredData.Entry>> types = this.jsonMessageObject.getTypes();
        HashSet<String> deps = new HashSet<String>();
        if (!types.containsKey(primaryType)) {
            return deps;
        }
        ArrayList<String> remainingTypes = new ArrayList<String>();
        remainingTypes.add(primaryType);
        while (remainingTypes.size() > 0) {
            String structName = (String)remainingTypes.get(remainingTypes.size() - 1);
            remainingTypes.remove(remainingTypes.size() - 1);
            deps.add(structName);
            for (StructuredData.Entry entry : types.get(primaryType)) {
                if (!types.containsKey(entry.getType()) || deps.contains(entry.getType())) continue;
                remainingTypes.add(entry.getType());
            }
        }
        return deps;
    }

    public String encodeStruct(String structName) {
        HashMap<String, List<StructuredData.Entry>> types = this.jsonMessageObject.getTypes();
        StringBuilder structRepresentation = new StringBuilder(structName + "(");
        for (StructuredData.Entry entry : types.get(structName)) {
            structRepresentation.append(String.format("%s %s,", entry.getType(), entry.getName()));
        }
        structRepresentation = new StringBuilder(structRepresentation.substring(0, structRepresentation.length() - 1));
        structRepresentation.append(")");
        return structRepresentation.toString();
    }

    public String encodeType(String primaryType) {
        Set<String> deps = this.getDependencies(primaryType);
        deps.remove(primaryType);
        ArrayList<String> depsAsList = new ArrayList<String>(deps);
        Collections.sort(depsAsList);
        depsAsList.add(0, primaryType);
        StringBuilder result2 = new StringBuilder();
        for (String structName : depsAsList) {
            result2.append(this.encodeStruct(structName));
        }
        return result2.toString();
    }

    public byte[] typeHash(String primaryType) {
        return Numeric.hexStringToByteArray(Hash.sha3String(this.encodeType(primaryType)));
    }

    public List<Integer> getArrayDimensionsFromDeclaration(String declaration) {
        Matcher arrayTypeMatcher = this.arrayTypePattern.matcher(declaration);
        arrayTypeMatcher.find();
        String dimensionsString = arrayTypeMatcher.group(1);
        Matcher dimensionTypeMatcher = this.arrayDimensionPattern.matcher(dimensionsString);
        ArrayList<Integer> dimensions = new ArrayList<Integer>();
        while (dimensionTypeMatcher.find()) {
            String currentDimension = dimensionTypeMatcher.group(1);
            if (currentDimension == null) {
                dimensions.add(Integer.parseInt("-1"));
                continue;
            }
            dimensions.add(Integer.parseInt(currentDimension));
        }
        return dimensions;
    }

    public List<Pair> getDepthsAndDimensions(Object data2, int depth) {
        if (!(data2 instanceof List)) {
            return new ArrayList<Pair>();
        }
        ArrayList<Pair> list = new ArrayList<Pair>();
        List dataAsArray = (List)data2;
        list.add(new Pair(depth, dataAsArray.size()));
        for (Object subdimensionalData : dataAsArray) {
            list.addAll(this.getDepthsAndDimensions(subdimensionalData, depth + 1));
        }
        return list;
    }

    public List<Integer> getArrayDimensionsFromData(Object data2) throws RuntimeException {
        List<Pair> depthsAndDimensions = this.getDepthsAndDimensions(data2, 0);
        Map<Object, List<Pair>> groupedByDepth = depthsAndDimensions.stream().collect(Collectors.groupingBy(Pair::getFirst));
        HashMap depthDimensionsMap = new HashMap();
        for (Map.Entry<Object, List<Pair>> entry : groupedByDepth.entrySet()) {
            ArrayList<Integer> pureDimensions = new ArrayList<Integer>();
            for (Pair depthDimensionPair : entry.getValue()) {
                pureDimensions.add((Integer)depthDimensionPair.getSecond());
            }
            depthDimensionsMap.put((Integer)entry.getKey(), pureDimensions);
        }
        ArrayList<Integer> dimensions = new ArrayList<Integer>();
        for (Map.Entry entry : depthDimensionsMap.entrySet()) {
            TreeSet setOfDimensionsInParticularDepth = new TreeSet((Collection)entry.getValue());
            if (setOfDimensionsInParticularDepth.size() != 1) {
                throw new RuntimeException(String.format("Depth %d of array data has more than one dimensions", entry.getKey()));
            }
            dimensions.add((Integer)setOfDimensionsInParticularDepth.stream().findFirst().get());
        }
        return dimensions;
    }

    public List<Object> flattenMultidimensionalArray(final Object data2) {
        if (!(data2 instanceof List)) {
            return new ArrayList<Object>(){
                {
                    this.add(data2);
                }
            };
        }
        ArrayList<Object> flattenedArray = new ArrayList<Object>();
        for (Object arrayItem : (List)data2) {
            flattenedArray.addAll(this.flattenMultidimensionalArray(arrayItem));
        }
        return flattenedArray;
    }

    public byte[] encodeData(String primaryType, HashMap<String, Object> data2) throws RuntimeException {
        HashMap<String, List<StructuredData.Entry>> types = this.jsonMessageObject.getTypes();
        ArrayList<String> encTypes = new ArrayList<String>();
        ArrayList<Object> encValues = new ArrayList<Object>();
        encTypes.add("bytes32");
        encValues.add(this.typeHash(primaryType));
        for (StructuredData.Entry field : types.get(primaryType)) {
            byte[] hashedValue;
            Object value = data2.get(field.getName());
            if (field.getType().equals("string")) {
                encTypes.add("bytes32");
                hashedValue = Numeric.hexStringToByteArray(Hash.sha3String((String)value));
                encValues.add(hashedValue);
                continue;
            }
            if (field.getType().equals("bytes")) {
                encTypes.add("bytes32");
                encValues.add(Hash.sha3(Numeric.hexStringToByteArray((String)value)));
                continue;
            }
            if (types.containsKey(field.getType())) {
                hashedValue = Hash.sha3(this.encodeData(field.getType(), (HashMap)value));
                encTypes.add("bytes32");
                encValues.add(hashedValue);
                continue;
            }
            if (this.bytesTypePattern.matcher(field.getType()).find()) {
                encTypes.add(field.getType());
                encValues.add(Numeric.hexStringToByteArray((String)value));
                continue;
            }
            if (this.arrayTypePattern.matcher(field.getType()).find()) {
                String baseTypeName = field.getType().substring(0, field.getType().indexOf(91));
                List<Integer> expectedDimensions = this.getArrayDimensionsFromDeclaration(field.getType());
                List<Integer> dataDimensions = this.getArrayDimensionsFromData(value);
                String format = String.format("Array Data %s has dimensions %s, but expected dimensions are %s", value.toString(), dataDimensions.toString(), expectedDimensions.toString());
                if (expectedDimensions.size() != dataDimensions.size()) {
                    throw new RuntimeException(format);
                }
                for (int i = 0; i < expectedDimensions.size(); ++i) {
                    if (expectedDimensions.get(i) == -1 || expectedDimensions.get(i).equals(dataDimensions.get(i))) continue;
                    throw new RuntimeException(format);
                }
                List<Object> arrayItems = this.flattenMultidimensionalArray(value);
                ByteArrayOutputStream concatenatedArrayEncodingBuffer = new ByteArrayOutputStream();
                for (Object arrayItem : arrayItems) {
                    byte[] arrayItemEncoding = this.encodeData(baseTypeName, (HashMap)arrayItem);
                    concatenatedArrayEncodingBuffer.write(arrayItemEncoding, 0, arrayItemEncoding.length);
                }
                byte[] concatenatedArrayEncodings = concatenatedArrayEncodingBuffer.toByteArray();
                byte[] hashedValue2 = Hash.sha3(concatenatedArrayEncodings);
                encTypes.add("bytes32");
                encValues.add(hashedValue2);
                continue;
            }
            encTypes.add(field.getType());
            encValues.add(value);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < encTypes.size(); ++i) {
            Constructor<?>[] constructors2;
            Class<? extends Type> typeClazz = AbiTypes.getType((String)encTypes.get(i));
            boolean atleastOneConstructorExistsForGivenParametersType = false;
            for (Constructor<?> constructor : constructors2 = typeClazz.getConstructors()) {
                try {
                    Class<?>[] parameterTypes = constructor.getParameterTypes();
                    byte[] temp = Numeric.hexStringToByteArray(TypeEncoder.encode(typeClazz.getDeclaredConstructor(parameterTypes).newInstance(encValues.get(i))));
                    baos.write(temp, 0, temp.length);
                    atleastOneConstructorExistsForGivenParametersType = true;
                    break;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                }
            }
            if (atleastOneConstructorExistsForGivenParametersType) continue;
            throw new RuntimeException(String.format("Received an invalid argument for which no constructor exists for the ABI Class %s", typeClazz.getSimpleName()));
        }
        byte[] result2 = baos.toByteArray();
        return result2;
    }

    public byte[] hashMessage(String primaryType, HashMap<String, Object> data2) throws RuntimeException {
        return Hash.sha3(this.encodeData(primaryType, data2));
    }

    public byte[] hashDomain() throws RuntimeException {
        ObjectMapper oMapper = new ObjectMapper();
        HashMap data2 = oMapper.convertValue((Object)this.jsonMessageObject.getDomain(), HashMap.class);
        if (data2.get("chainId") != null) {
            data2.put("chainId", ((HashMap)data2.get("chainId")).get("value"));
        } else {
            data2.remove("chainId");
        }
        data2.put("verifyingContract", ((HashMap)data2.get("verifyingContract")).get("value"));
        return Hash.sha3(this.encodeData("EIP712Domain", data2));
    }

    public void validateStructuredData(StructuredData.EIP712Message jsonMessageObject) throws RuntimeException {
        for (String structName : jsonMessageObject.getTypes().keySet()) {
            List<StructuredData.Entry> fields2 = jsonMessageObject.getTypes().get(structName);
            for (StructuredData.Entry entry : fields2) {
                if (!this.identifierPattern.matcher(entry.getName()).find()) {
                    throw new RuntimeException(String.format("Invalid Identifier %s in %s", entry.getName(), structName));
                }
                if (this.typePattern.matcher(entry.getType()).find()) continue;
                throw new RuntimeException(String.format("Invalid Type %s in %s", entry.getType(), structName));
            }
        }
    }

    public StructuredData.EIP712Message parseJSONMessage(String jsonMessageInString) throws IOException, RuntimeException {
        ObjectMapper mapper = new ObjectMapper();
        StructuredData.EIP712Message tempJSONMessageObject = mapper.readValue(jsonMessageInString, StructuredData.EIP712Message.class);
        this.validateStructuredData(tempJSONMessageObject);
        return tempJSONMessageObject;
    }

    public byte[] hashStructuredData() throws RuntimeException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String messagePrefix = "\u0019\u0001";
        byte[] prefix = "\u0019\u0001".getBytes();
        baos.write(prefix, 0, prefix.length);
        byte[] domainHash = this.hashDomain();
        baos.write(domainHash, 0, domainHash.length);
        byte[] dataHash = this.hashMessage(this.jsonMessageObject.getPrimaryType(), (HashMap)this.jsonMessageObject.getMessage());
        baos.write(dataHash, 0, dataHash.length);
        byte[] result2 = baos.toByteArray();
        return Hash.sha3(result2);
    }
}

