/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.parity.methods.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.web3j.utils.Numeric;

public class Trace {
    private Action action;
    private String error;
    private Result result;
    private BigInteger subtraces;
    private List<BigInteger> traceAddress;
    private String type;
    private String blockHash;
    private BigInteger blockNumber;
    private String transactionHash;
    private BigInteger transactionPosition;

    public Trace() {
    }

    public Trace(Action action, String error, Result result2, BigInteger subtraces, List<BigInteger> traceAddress, String type2, String blockHash, BigInteger blockNumber, String transactionHash, BigInteger transactionPosition) {
        this.action = action;
        this.error = error;
        this.result = result2;
        this.subtraces = subtraces;
        this.traceAddress = traceAddress;
        this.type = type2;
        this.blockHash = blockHash;
        this.blockNumber = blockNumber;
        this.transactionHash = transactionHash;
        this.transactionPosition = transactionPosition;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result2) {
        this.result = result2;
    }

    public BigInteger getSubtraces() {
        return this.subtraces;
    }

    public void setSubtraces(BigInteger subtraces) {
        this.subtraces = subtraces;
    }

    public List<BigInteger> getTraceAddress() {
        return this.traceAddress;
    }

    public void setTraceAddress(List<BigInteger> traceAddress) {
        this.traceAddress = traceAddress;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type2) {
        this.type = type2;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public BigInteger getTransactionPosition() {
        return this.transactionPosition;
    }

    public void setTransactionPosition(BigInteger transactionPosition) {
        this.transactionPosition = transactionPosition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Trace)) {
            return false;
        }
        Trace trace = (Trace)o;
        if (this.getAction() != null ? !this.getAction().equals(trace.getAction()) : trace.getAction() != null) {
            return false;
        }
        if (this.getError() != null ? !this.getError().equals(trace.getError()) : trace.getError() != null) {
            return false;
        }
        if (this.getResult() != null ? !this.getResult().equals(trace.getResult()) : trace.getResult() != null) {
            return false;
        }
        if (this.getSubtraces() != null ? !this.getSubtraces().equals(trace.getSubtraces()) : trace.getSubtraces() != null) {
            return false;
        }
        if (this.getTraceAddress() != null ? !this.getTraceAddress().equals(trace.getTraceAddress()) : trace.getTraceAddress() != null) {
            return false;
        }
        if (this.getType() != null ? !this.getType().equals(trace.getType()) : trace.getType() != null) {
            return false;
        }
        if (this.getBlockHash() != null ? !this.getBlockHash().equals(trace.getBlockHash()) : trace.getBlockHash() != null) {
            return false;
        }
        if (this.getBlockNumber() != null ? !this.getBlockNumber().equals(trace.getBlockNumber()) : trace.getBlockNumber() != null) {
            return false;
        }
        if (this.getTransactionHash() != null ? !this.getTransactionHash().equals(trace.getTransactionHash()) : trace.getTransactionHash() != null) {
            return false;
        }
        return this.getTransactionPosition() != null ? this.getTransactionPosition().equals(trace.getTransactionPosition()) : trace.getTransactionPosition() == null;
    }

    public int hashCode() {
        int result1 = this.getAction() != null ? this.getAction().hashCode() : 0;
        result1 = 31 * result1 + (this.getError() != null ? this.getError().hashCode() : 0);
        result1 = 31 * result1 + (this.getResult() != null ? this.getResult().hashCode() : 0);
        result1 = 31 * result1 + (this.getSubtraces() != null ? this.getSubtraces().hashCode() : 0);
        result1 = 31 * result1 + (this.getTraceAddress() != null ? this.getTraceAddress().hashCode() : 0);
        result1 = 31 * result1 + (this.getType() != null ? this.getType().hashCode() : 0);
        result1 = 31 * result1 + (this.getBlockHash() != null ? this.getBlockHash().hashCode() : 0);
        result1 = 31 * result1 + (this.getBlockNumber() != null ? this.getBlockNumber().hashCode() : 0);
        result1 = 31 * result1 + (this.getTransactionHash() != null ? this.getTransactionHash().hashCode() : 0);
        result1 = 31 * result1 + (this.getTransactionPosition() != null ? this.getTransactionPosition().hashCode() : 0);
        return result1;
    }

    public String toString() {
        return "Trace{action=" + this.getAction() + ", error='" + this.getError() + '\'' + ", result=" + this.getResult() + ", subtraces=" + this.getSubtraces() + ", traceAddress=" + this.getTraceAddress() + ", type='" + this.getType() + '\'' + ", blockHash='" + this.getBlockHash() + '\'' + ", blockNumber=" + this.getBlockNumber() + ", transactionHash='" + this.getTransactionHash() + '\'' + ", transactionPosition=" + this.getTransactionPosition() + '}';
    }

    public static class ActionDeserializer
    extends JsonDeserializer<Action> {
        @Override
        public Action deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            ObjectMapper objectMapper = (ObjectMapper)jsonParser.getCodec();
            ObjectNode root = (ObjectNode)objectMapper.readTree(jsonParser);
            if (root.has("callType")) {
                return objectMapper.convertValue((Object)root, CallAction.class);
            }
            if (root.has("init")) {
                return objectMapper.convertValue((Object)root, CreateAction.class);
            }
            if (root.has("refundAddress")) {
                return objectMapper.convertValue((Object)root, SuicideAction.class);
            }
            if (root.has("rewardType")) {
                return objectMapper.convertValue((Object)root, RewardAction.class);
            }
            return null;
        }
    }

    public static class Result {
        private String address;
        private String code;
        private String gasUsed;
        private String output;

        public Result() {
        }

        public Result(String address, String code, String gasUsed, String output) {
            this.address = address;
            this.code = code;
            this.gasUsed = gasUsed;
            this.output = output;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public BigInteger getGasUsed() {
            return Numeric.decodeQuantity(this.gasUsed);
        }

        public String getGasUsedRaw() {
            return this.gasUsed;
        }

        public void setGasUsed(String gasUsed) {
            this.gasUsed = gasUsed;
        }

        public String getOutput() {
            return this.output;
        }

        public void setOutput(String output) {
            this.output = output;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Result)) {
                return false;
            }
            Result result2 = (Result)o;
            if (this.getAddress() != null ? !this.getAddress().equals(result2.getAddress()) : result2.getAddress() != null) {
                return false;
            }
            if (this.getCode() != null ? !this.getCode().equals(result2.getCode()) : result2.getCode() != null) {
                return false;
            }
            if (this.getGasUsedRaw() != null ? !this.getGasUsedRaw().equals(result2.getGasUsedRaw()) : result2.getGasUsedRaw() != null) {
                return false;
            }
            return this.getOutput() != null ? this.getOutput().equals(result2.getOutput()) : result2.getOutput() == null;
        }

        public int hashCode() {
            int result2 = this.getAddress() != null ? this.getAddress().hashCode() : 0;
            result2 = 31 * result2 + (this.getCode() != null ? this.getCode().hashCode() : 0);
            result2 = 31 * result2 + (this.getGasUsedRaw() != null ? this.getGasUsedRaw().hashCode() : 0);
            result2 = 31 * result2 + (this.getOutput() != null ? this.getOutput().hashCode() : 0);
            return result2;
        }

        public String toString() {
            return "Result{address='" + this.getAddress() + '\'' + ", code='" + this.getCode() + '\'' + ", gasUsed='" + this.getGasUsedRaw() + '\'' + ", output='" + this.getOutput() + '\'' + '}';
        }
    }

    @JsonDeserialize
    public static class RewardAction
    implements Action {
        private String author;
        private String value;
        private String rewardType;

        public RewardAction() {
        }

        public RewardAction(String author, String value, String rewardType) {
            this.author = author;
            this.value = value;
            this.rewardType = rewardType;
        }

        public BigInteger getValue() {
            return Numeric.decodeQuantity(this.value);
        }

        public String getValueRaw() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public String getRewardType() {
            return this.rewardType;
        }

        public void setRewardType(String rewardType) {
            this.rewardType = rewardType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RewardAction)) {
                return false;
            }
            RewardAction that = (RewardAction)o;
            if (this.getAuthor() != null ? !this.getAuthor().equals(that.getAuthor()) : that.getAuthor() != null) {
                return false;
            }
            if (this.getValueRaw() != null ? !this.getValueRaw().equals(that.getValueRaw()) : that.getValueRaw() != null) {
                return false;
            }
            return this.getRewardType() != null ? this.getRewardType().equals(that.getRewardType()) : that.getRewardType() == null;
        }

        public int hashCode() {
            int result2 = this.getAuthor() != null ? this.getAuthor().hashCode() : 0;
            result2 = 31 * result2 + (this.getValueRaw() != null ? this.getValueRaw().hashCode() : 0);
            result2 = 31 * result2 + (this.getRewardType() != null ? this.getRewardType().hashCode() : 0);
            return result2;
        }

        public String toString() {
            return "RewardAction{author='" + this.getAuthor() + '\'' + ", value='" + this.getValueRaw() + '\'' + ", rewardType='" + this.getRewardType() + '\'' + '}';
        }
    }

    @JsonDeserialize
    public static class CreateAction
    implements Action {
        private String from;
        private String gas;
        private String value;
        private String init;

        public CreateAction() {
        }

        public CreateAction(String from, String gas, String value, String init) {
            this.from = from;
            this.gas = gas;
            this.value = value;
            this.init = init;
        }

        public BigInteger getValue() {
            return Numeric.decodeQuantity(this.value);
        }

        public String getValueRaw() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public BigInteger getGas() {
            return Numeric.decodeQuantity(this.gas);
        }

        public String getGasRaw() {
            return this.gas;
        }

        public void setGas(String gas) {
            this.gas = gas;
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getInit() {
            return this.init;
        }

        public void setInit(String init) {
            this.init = init;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CreateAction)) {
                return false;
            }
            CreateAction that = (CreateAction)o;
            if (this.getFrom() != null ? !this.getFrom().equals(that.getFrom()) : that.getFrom() != null) {
                return false;
            }
            if (this.getGasRaw() != null ? !this.getGasRaw().equals(that.getGasRaw()) : that.getGasRaw() != null) {
                return false;
            }
            if (this.getValueRaw() != null ? !this.getValueRaw().equals(that.getValueRaw()) : that.getValueRaw() != null) {
                return false;
            }
            return this.getInit() != null ? this.getInit().equals(that.getInit()) : that.getInit() == null;
        }

        public int hashCode() {
            int result2 = this.getFrom() != null ? this.getFrom().hashCode() : 0;
            result2 = 31 * result2 + (this.getGasRaw() != null ? this.getGasRaw().hashCode() : 0);
            result2 = 31 * result2 + (this.getValueRaw() != null ? this.getValueRaw().hashCode() : 0);
            result2 = 31 * result2 + (this.getInit() != null ? this.getInit().hashCode() : 0);
            return result2;
        }

        public String toString() {
            return "CreateAction{from='" + this.getFrom() + '\'' + ", gas='" + this.getGasRaw() + '\'' + ", value='" + this.getValueRaw() + '\'' + ", init='" + this.getInit() + '\'' + '}';
        }
    }

    @JsonDeserialize
    public static class CallAction
    implements Action {
        private String callType;
        private String from;
        private String to;
        private String gas;
        private String input;
        private String value;

        public CallAction() {
        }

        public CallAction(String callType, String from, String to, String gas, String input, String value) {
            this.callType = callType;
            this.from = from;
            this.to = to;
            this.gas = gas;
            this.input = input;
            this.value = value;
        }

        public String getCallType() {
            return this.callType;
        }

        public void setCallType(String callType) {
            this.callType = callType;
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getTo() {
            return this.to;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public BigInteger getGas() {
            return Numeric.decodeQuantity(this.gas);
        }

        public String getGasRaw() {
            return this.gas;
        }

        public void setGas(String gas) {
            this.gas = gas;
        }

        public String getInput() {
            return this.input;
        }

        public void setInput(String input) {
            this.input = input;
        }

        public BigInteger getValue() {
            return Numeric.decodeQuantity(this.value);
        }

        public String getValueRaw() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CallAction)) {
                return false;
            }
            CallAction that = (CallAction)o;
            if (this.getCallType() != null ? !this.getCallType().equals(that.getCallType()) : that.getCallType() != null) {
                return false;
            }
            if (this.getFrom() != null ? !this.getFrom().equals(that.getFrom()) : that.getFrom() != null) {
                return false;
            }
            if (this.getTo() != null ? !this.getTo().equals(that.getTo()) : that.getTo() != null) {
                return false;
            }
            if (this.getGasRaw() != null ? !this.getGasRaw().equals(that.getGasRaw()) : that.getGasRaw() != null) {
                return false;
            }
            if (this.getInput() != null ? !this.getInput().equals(that.getInput()) : that.getInput() != null) {
                return false;
            }
            return this.getValueRaw() != null ? this.getValueRaw().equals(that.getValueRaw()) : that.getValueRaw() == null;
        }

        public int hashCode() {
            int result2 = this.getCallType() != null ? this.getCallType().hashCode() : 0;
            result2 = 31 * result2 + (this.getFrom() != null ? this.getFrom().hashCode() : 0);
            result2 = 31 * result2 + (this.getTo() != null ? this.getTo().hashCode() : 0);
            result2 = 31 * result2 + (this.getGasRaw() != null ? this.getGasRaw().hashCode() : 0);
            result2 = 31 * result2 + (this.getInput() != null ? this.getInput().hashCode() : 0);
            result2 = 31 * result2 + (this.getValueRaw() != null ? this.getValueRaw().hashCode() : 0);
            return result2;
        }

        public String toString() {
            return "CallAction{callType='" + this.getCallType() + '\'' + ", from='" + this.getFrom() + '\'' + ", to='" + this.getTo() + '\'' + ", gas='" + this.getGasRaw() + '\'' + ", input='" + this.getInput() + '\'' + ", value='" + this.getValueRaw() + '\'' + '}';
        }
    }

    @JsonDeserialize
    public static class SuicideAction
    implements Action {
        private String address;
        private String balance;
        private String refundAddress;

        public SuicideAction() {
        }

        public SuicideAction(String address, String balance, String refundAddress) {
            this.address = address;
            this.balance = balance;
            this.refundAddress = refundAddress;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public BigInteger getBalance() {
            return Numeric.decodeQuantity(this.balance);
        }

        public String getBalanceRaw() {
            return this.balance;
        }

        public void setBalance(String balance) {
            this.balance = balance;
        }

        public String getRefundAddress() {
            return this.refundAddress;
        }

        public void setRefundAddress(String refundAddress) {
            this.refundAddress = refundAddress;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof SuicideAction)) {
                return false;
            }
            SuicideAction that = (SuicideAction)o;
            if (this.getAddress() != null ? !this.getAddress().equals(that.getAddress()) : that.getAddress() != null) {
                return false;
            }
            if (this.getBalanceRaw() != null ? !this.getBalanceRaw().equals(that.getBalanceRaw()) : that.getBalanceRaw() != null) {
                return false;
            }
            return this.getRefundAddress() != null ? this.getRefundAddress().equals(that.getRefundAddress()) : that.getRefundAddress() == null;
        }

        public int hashCode() {
            int result2 = this.getAddress() != null ? this.getAddress().hashCode() : 0;
            result2 = 31 * result2 + (this.getBalanceRaw() != null ? this.getBalanceRaw().hashCode() : 0);
            result2 = 31 * result2 + (this.getRefundAddress() != null ? this.getRefundAddress().hashCode() : 0);
            return result2;
        }

        public String toString() {
            return "SuicideAction{address='" + this.getAddress() + '\'' + ", balance='" + this.getBalanceRaw() + '\'' + ", refundAddress='" + this.getRefundAddress() + '\'' + '}';
        }
    }

    @JsonDeserialize(using=ActionDeserializer.class)
    public static interface Action {
    }
}

