/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.quorum;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import javax.net.SocketFactory;
import jnr.unixsocket.UnixSocket;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;

public final class UnixDomainSocketFactory
extends SocketFactory {
    private final File path;

    public UnixDomainSocketFactory(File path) {
        this.path = path;
    }

    private Socket createUnixDomainSocket() throws IOException {
        UnixSocketChannel channel = UnixSocketChannel.open();
        return new UnixSocket(channel){
            private InetSocketAddress inetSocketAddress;

            @Override
            public void connect(SocketAddress endpoint) throws IOException {
                this.connect(endpoint, (Integer)0);
            }

            @Override
            public void connect(SocketAddress endpoint, int timeout2) throws IOException {
                this.connect(endpoint, (Integer)timeout2);
            }

            @Override
            public void connect(SocketAddress endpoint, Integer timeout2) throws IOException {
                this.inetSocketAddress = (InetSocketAddress)endpoint;
                super.connect(new UnixSocketAddress(UnixDomainSocketFactory.this.path), timeout2);
            }

            @Override
            public InetAddress getInetAddress() {
                return this.inetSocketAddress.getAddress();
            }
        };
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.createUnixDomainSocket();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.createUnixDomainSocket();
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.createUnixDomainSocket();
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.createUnixDomainSocket();
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.createUnixDomainSocket();
    }
}

