/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.webhook;

import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.webhook.WebhookEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class WebhookEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        WebhookEndpoint target = (WebhookEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(WebhookEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(WebhookEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(WebhookEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "webhookautoregister": 
            case "webhookAutoRegister": {
                target.getConfiguration().setWebhookAutoRegister(WebhookEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "webhookbasepath": 
            case "webhookBasePath": {
                target.getConfiguration().setWebhookBasePath(WebhookEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "webhookcomponentname": 
            case "webhookComponentName": {
                target.getConfiguration().setWebhookComponentName(WebhookEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "webhookexternalurl": 
            case "webhookExternalUrl": {
                target.getConfiguration().setWebhookExternalUrl(WebhookEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "webhookpath": 
            case "webhookPath": {
                target.getConfiguration().setWebhookPath(WebhookEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "webhookautoregister": 
            case "webhookAutoRegister": {
                return Boolean.TYPE;
            }
            case "webhookbasepath": 
            case "webhookBasePath": {
                return String.class;
            }
            case "webhookcomponentname": 
            case "webhookComponentName": {
                return String.class;
            }
            case "webhookexternalurl": 
            case "webhookExternalUrl": {
                return String.class;
            }
            case "webhookpath": 
            case "webhookPath": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        WebhookEndpoint target = (WebhookEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "webhookautoregister": 
            case "webhookAutoRegister": {
                return target.getConfiguration().isWebhookAutoRegister();
            }
            case "webhookbasepath": 
            case "webhookBasePath": {
                return target.getConfiguration().getWebhookBasePath();
            }
            case "webhookcomponentname": 
            case "webhookComponentName": {
                return target.getConfiguration().getWebhookComponentName();
            }
            case "webhookexternalurl": 
            case "webhookExternalUrl": {
                return target.getConfiguration().getWebhookExternalUrl();
            }
            case "webhookpath": 
            case "webhookPath": {
                return target.getConfiguration().getWebhookPath();
            }
        }
        return null;
    }
}

