/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xchange;

import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;

@UriParams
public class XChangeConfiguration {
    @Metadata(description="The target currency", javaType="org.knowm.xchange.currency.Currency")
    public static final String HEADER_CURRENCY = "Currency";
    @Metadata(description="The target currency pair", javaType="org.knowm.xchange.currency.CurrencyPair")
    public static final String HEADER_CURRENCY_PAIR = "CurrencyPair";
    @UriPath(description="The exchange to connect to")
    @Metadata(required=true)
    private String name;
    @UriParam(description="The service to call")
    @Metadata(required=true)
    private XChangeService service;
    @UriParam(description="The method to execute")
    @Metadata(required=true)
    private XChangeMethod method;
    @UriParam(description="The currency")
    private Currency currency;
    @UriParam(description="The currency pair")
    private String currencyPair;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public XChangeService getService() {
        return this.service;
    }

    public void setService(XChangeService service) {
        this.service = service;
    }

    public XChangeMethod getMethod() {
        return this.method;
    }

    public void setMethod(XChangeMethod method) {
        this.method = method;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setCurrency(String curr) {
        this.currency = Currency.getInstanceNoCreate(curr);
    }

    public CurrencyPair getAsCurrencyPair() {
        if (this.currencyPair != null) {
            return new CurrencyPair(this.currencyPair);
        }
        return null;
    }

    public String getCurrencyPair() {
        return this.currencyPair;
    }

    public void setCurrencyPair(String currencyPair) {
        this.currencyPair = currencyPair;
    }

    public static enum XChangeService {
        marketdata,
        metadata,
        account;

    }

    public static enum XChangeMethod {
        balances,
        fundingHistory,
        wallets,
        currencies,
        currencyMetaData,
        currencyPairs,
        currencyPairMetaData,
        ticker;

    }
}

