/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.BinanceErrorAdapter;
import org.knowm.xchange.binance.BinanceExchange;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.binance.dto.marketdata.BinanceOrderbook;
import org.knowm.xchange.binance.dto.marketdata.BinanceTicker24h;
import org.knowm.xchange.binance.service.BinanceMarketDataServiceRaw;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.derivative.FuturesContract;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.FundingRate;
import org.knowm.xchange.dto.marketdata.FundingRates;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.service.marketdata.params.Params;

public class BinanceMarketDataService
extends BinanceMarketDataServiceRaw
implements MarketDataService {
    public BinanceMarketDataService(BinanceExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    @Override
    public Trades getTrades(Instrument instrument, Object ... args) throws IOException {
        return this.getBinanceTrades(instrument, args);
    }

    @Override
    public Ticker getTicker(Instrument instrument, Object ... args) throws IOException {
        try {
            return BinanceAdapters.toTicker(this.ticker24hAllProducts(instrument), instrument instanceof FuturesContract);
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    @Override
    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        return this.getTicker((Instrument)currencyPair, args);
    }

    @Override
    public List<Ticker> getTickers(Params params) throws IOException {
        try {
            boolean isFutures = ((BinanceExchange)this.exchange).isFuturesEnabled();
            return this.ticker24hAllProducts(isFutures).stream().filter(BinanceTicker24h::isValid).map(binanceTicker24h -> BinanceAdapters.toTicker(binanceTicker24h, isFutures)).collect(Collectors.toList());
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    @Override
    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        return this.getOrderBook((Instrument)currencyPair, args);
    }

    @Override
    public OrderBook getOrderBook(Instrument instrument, Object ... args) throws IOException {
        return this.getBinanceOrderBook(instrument, args);
    }

    @Override
    public FundingRates getFundingRates() throws IOException {
        return BinanceAdapters.adaptFundingRates(this.getBinanceFundingRates());
    }

    @Override
    public FundingRate getFundingRate(Instrument instrument) throws IOException {
        return BinanceAdapters.adaptFundingRate(this.getBinanceFundingRate(instrument));
    }

    private Trades getBinanceTrades(Instrument instrument, Object ... args) throws IOException {
        try {
            Long fromId = this.tradesArgument(args, 0, Long::valueOf);
            Long startTime = this.tradesArgument(args, 1, Long::valueOf);
            Long endTime = this.tradesArgument(args, 2, Long::valueOf);
            Integer limit = this.tradesArgument(args, 3, Integer::valueOf);
            return BinanceAdapters.adaptTrades(this.aggTradesAllProducts(instrument, fromId, startTime, endTime, limit), instrument);
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    private OrderBook getBinanceOrderBook(Instrument instrument, Object ... args) throws IOException {
        try {
            int limitDepth = 100;
            if (args != null && args.length == 1) {
                Object arg0 = args[0];
                if (!(arg0 instanceof Integer)) {
                    throw new ExchangeException("Argument 0 must be an Integer!");
                }
                limitDepth = (Integer)arg0;
            }
            BinanceOrderbook binanceOrderbook = this.getBinanceOrderbookAllProducts(instrument, limitDepth);
            return BinanceMarketDataService.convertOrderBook(binanceOrderbook, instrument);
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public static OrderBook convertOrderBook(BinanceOrderbook ob, Instrument pair) {
        List<LimitOrder> bids = ob.bids.entrySet().stream().map(e -> new LimitOrder(Order.OrderType.BID, (BigDecimal)e.getValue(), pair, null, null, (BigDecimal)e.getKey())).collect(Collectors.toList());
        List<LimitOrder> asks = ob.asks.entrySet().stream().map(e -> new LimitOrder(Order.OrderType.ASK, (BigDecimal)e.getValue(), pair, null, null, (BigDecimal)e.getKey())).collect(Collectors.toList());
        return new OrderBook(Date.from(Instant.now()), asks, bids);
    }

    private <T extends Number> T tradesArgument(Object[] args, int index, Function<String, T> converter) {
        if (index >= args.length) {
            return null;
        }
        Object arg = args[index];
        if (arg == null) {
            return null;
        }
        String argStr = arg.toString();
        try {
            return (T)((Number)converter.apply(argStr));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Argument on index " + index + " is not a number: " + argStr, e);
        }
    }
}

