/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.service.account.params;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Arrays;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.service.account.params.RequestDepositAddressParams;

@JsonDeserialize(builder=DefaultRequestDepositAddressParamsBuilder.class)
public class DefaultRequestDepositAddressParams
implements RequestDepositAddressParams {
    private final Currency currency;
    private final String network;
    private final boolean newAddress;
    private final String[] extraArguments;

    public static DefaultRequestDepositAddressParams create(Currency currency, String ... args) {
        return DefaultRequestDepositAddressParams.builder().currency(currency).extraArguments(args).build();
    }

    private static boolean $default$newAddress() {
        return false;
    }

    DefaultRequestDepositAddressParams(Currency currency, String network, boolean newAddress, String[] extraArguments) {
        this.currency = currency;
        this.network = network;
        this.newAddress = newAddress;
        this.extraArguments = extraArguments;
    }

    public static DefaultRequestDepositAddressParamsBuilder builder() {
        return new DefaultRequestDepositAddressParamsBuilder();
    }

    @Override
    public Currency getCurrency() {
        return this.currency;
    }

    @Override
    public String getNetwork() {
        return this.network;
    }

    @Override
    public boolean isNewAddress() {
        return this.newAddress;
    }

    @Override
    public String[] getExtraArguments() {
        return this.extraArguments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultRequestDepositAddressParams)) {
            return false;
        }
        DefaultRequestDepositAddressParams other = (DefaultRequestDepositAddressParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNewAddress() != other.isNewAddress()) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !((Object)this$currency).equals(other$currency)) {
            return false;
        }
        String this$network = this.getNetwork();
        String other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
            return false;
        }
        return Arrays.deepEquals(this.getExtraArguments(), other.getExtraArguments());
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultRequestDepositAddressParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNewAddress() ? 79 : 97);
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : ((Object)$currency).hashCode());
        String $network = this.getNetwork();
        result = result * 59 + ($network == null ? 43 : $network.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getExtraArguments());
        return result;
    }

    public String toString() {
        return "DefaultRequestDepositAddressParams(currency=" + this.getCurrency() + ", network=" + this.getNetwork() + ", newAddress=" + this.isNewAddress() + ", extraArguments=" + Arrays.deepToString(this.getExtraArguments()) + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class DefaultRequestDepositAddressParamsBuilder {
        private Currency currency;
        private String network;
        private boolean newAddress$set;
        private boolean newAddress$value;
        private String[] extraArguments;

        DefaultRequestDepositAddressParamsBuilder() {
        }

        public DefaultRequestDepositAddressParamsBuilder currency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public DefaultRequestDepositAddressParamsBuilder network(String network) {
            this.network = network;
            return this;
        }

        public DefaultRequestDepositAddressParamsBuilder newAddress(boolean newAddress) {
            this.newAddress$value = newAddress;
            this.newAddress$set = true;
            return this;
        }

        public DefaultRequestDepositAddressParamsBuilder extraArguments(String[] extraArguments) {
            this.extraArguments = extraArguments;
            return this;
        }

        public DefaultRequestDepositAddressParams build() {
            boolean newAddress$value = this.newAddress$value;
            if (!this.newAddress$set) {
                newAddress$value = DefaultRequestDepositAddressParams.$default$newAddress();
            }
            return new DefaultRequestDepositAddressParams(this.currency, this.network, newAddress$value, this.extraArguments);
        }

        public String toString() {
            return "DefaultRequestDepositAddressParams.DefaultRequestDepositAddressParamsBuilder(currency=" + this.currency + ", network=" + this.network + ", newAddress$value=" + this.newAddress$value + ", extraArguments=" + Arrays.deepToString(this.extraArguments) + ")";
        }
    }
}

