/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigDecimal;
import org.apache.commons.lang3.ObjectUtils;
import org.knowm.xchange.binance.config.converter.StringToCurrencyPairConverter;
import org.knowm.xchange.currency.CurrencyPair;

@JsonDeserialize(builder=BinancePriceQuantityBuilder.class)
public final class BinancePriceQuantity {
    @JsonProperty(value="symbol")
    @JsonDeserialize(converter=StringToCurrencyPairConverter.class)
    CurrencyPair currencyPair;
    @JsonProperty(value="bidPrice")
    BigDecimal bidPrice;
    @JsonProperty(value="bidQty")
    BigDecimal bidQty;
    @JsonProperty(value="askPrice")
    BigDecimal askPrice;
    @JsonProperty(value="askQty")
    BigDecimal askQty;

    public boolean isValid() {
        return ObjectUtils.allNotNull(this.currencyPair, this.bidPrice, this.bidQty, this.askPrice, this.askQty);
    }

    BinancePriceQuantity(CurrencyPair currencyPair, BigDecimal bidPrice, BigDecimal bidQty, BigDecimal askPrice, BigDecimal askQty) {
        this.currencyPair = currencyPair;
        this.bidPrice = bidPrice;
        this.bidQty = bidQty;
        this.askPrice = askPrice;
        this.askQty = askQty;
    }

    public static BinancePriceQuantityBuilder builder() {
        return new BinancePriceQuantityBuilder();
    }

    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    public BigDecimal getBidPrice() {
        return this.bidPrice;
    }

    public BigDecimal getBidQty() {
        return this.bidQty;
    }

    public BigDecimal getAskPrice() {
        return this.askPrice;
    }

    public BigDecimal getAskQty() {
        return this.askQty;
    }

    @JsonProperty(value="symbol")
    @JsonDeserialize(converter=StringToCurrencyPairConverter.class)
    public void setCurrencyPair(CurrencyPair currencyPair) {
        this.currencyPair = currencyPair;
    }

    @JsonProperty(value="bidPrice")
    public void setBidPrice(BigDecimal bidPrice) {
        this.bidPrice = bidPrice;
    }

    @JsonProperty(value="bidQty")
    public void setBidQty(BigDecimal bidQty) {
        this.bidQty = bidQty;
    }

    @JsonProperty(value="askPrice")
    public void setAskPrice(BigDecimal askPrice) {
        this.askPrice = askPrice;
    }

    @JsonProperty(value="askQty")
    public void setAskQty(BigDecimal askQty) {
        this.askQty = askQty;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinancePriceQuantity)) {
            return false;
        }
        BinancePriceQuantity other = (BinancePriceQuantity)o;
        CurrencyPair this$currencyPair = this.getCurrencyPair();
        CurrencyPair other$currencyPair = other.getCurrencyPair();
        if (this$currencyPair == null ? other$currencyPair != null : !((Object)this$currencyPair).equals(other$currencyPair)) {
            return false;
        }
        BigDecimal this$bidPrice = this.getBidPrice();
        BigDecimal other$bidPrice = other.getBidPrice();
        if (this$bidPrice == null ? other$bidPrice != null : !((Object)this$bidPrice).equals(other$bidPrice)) {
            return false;
        }
        BigDecimal this$bidQty = this.getBidQty();
        BigDecimal other$bidQty = other.getBidQty();
        if (this$bidQty == null ? other$bidQty != null : !((Object)this$bidQty).equals(other$bidQty)) {
            return false;
        }
        BigDecimal this$askPrice = this.getAskPrice();
        BigDecimal other$askPrice = other.getAskPrice();
        if (this$askPrice == null ? other$askPrice != null : !((Object)this$askPrice).equals(other$askPrice)) {
            return false;
        }
        BigDecimal this$askQty = this.getAskQty();
        BigDecimal other$askQty = other.getAskQty();
        return !(this$askQty == null ? other$askQty != null : !((Object)this$askQty).equals(other$askQty));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CurrencyPair $currencyPair = this.getCurrencyPair();
        result = result * 59 + ($currencyPair == null ? 43 : ((Object)$currencyPair).hashCode());
        BigDecimal $bidPrice = this.getBidPrice();
        result = result * 59 + ($bidPrice == null ? 43 : ((Object)$bidPrice).hashCode());
        BigDecimal $bidQty = this.getBidQty();
        result = result * 59 + ($bidQty == null ? 43 : ((Object)$bidQty).hashCode());
        BigDecimal $askPrice = this.getAskPrice();
        result = result * 59 + ($askPrice == null ? 43 : ((Object)$askPrice).hashCode());
        BigDecimal $askQty = this.getAskQty();
        result = result * 59 + ($askQty == null ? 43 : ((Object)$askQty).hashCode());
        return result;
    }

    public String toString() {
        return "BinancePriceQuantity(currencyPair=" + this.getCurrencyPair() + ", bidPrice=" + this.getBidPrice() + ", bidQty=" + this.getBidQty() + ", askPrice=" + this.getAskPrice() + ", askQty=" + this.getAskQty() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class BinancePriceQuantityBuilder {
        private CurrencyPair currencyPair;
        private BigDecimal bidPrice;
        private BigDecimal bidQty;
        private BigDecimal askPrice;
        private BigDecimal askQty;

        BinancePriceQuantityBuilder() {
        }

        @JsonProperty(value="symbol")
        @JsonDeserialize(converter=StringToCurrencyPairConverter.class)
        public BinancePriceQuantityBuilder currencyPair(CurrencyPair currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        @JsonProperty(value="bidPrice")
        public BinancePriceQuantityBuilder bidPrice(BigDecimal bidPrice) {
            this.bidPrice = bidPrice;
            return this;
        }

        @JsonProperty(value="bidQty")
        public BinancePriceQuantityBuilder bidQty(BigDecimal bidQty) {
            this.bidQty = bidQty;
            return this;
        }

        @JsonProperty(value="askPrice")
        public BinancePriceQuantityBuilder askPrice(BigDecimal askPrice) {
            this.askPrice = askPrice;
            return this;
        }

        @JsonProperty(value="askQty")
        public BinancePriceQuantityBuilder askQty(BigDecimal askQty) {
            this.askQty = askQty;
            return this;
        }

        public BinancePriceQuantity build() {
            return new BinancePriceQuantity(this.currencyPair, this.bidPrice, this.bidQty, this.askPrice, this.askQty);
        }

        public String toString() {
            return "BinancePriceQuantity.BinancePriceQuantityBuilder(currencyPair=" + this.currencyPair + ", bidPrice=" + this.bidPrice + ", bidQty=" + this.bidQty + ", askPrice=" + this.askPrice + ", askQty=" + this.askQty + ")";
        }
    }
}

