/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jxmpp.util.XmppStringUtils;

public final class StandardExtensionElement
implements ExtensionElement {
    private final String name;
    private final String namespace;
    private final Map<String, String> attributes;
    private final String text;
    private final MultiMap<String, StandardExtensionElement> elements;
    private XmlStringBuilder xmlCache;

    public StandardExtensionElement(String name, String namespace) {
        this(name, namespace, null, null, null);
    }

    private StandardExtensionElement(String name, String namespace, Map<String, String> attributes, String text, MultiMap<String, StandardExtensionElement> elements) {
        this.name = StringUtils.requireNotNullOrEmpty(name, "Name must not be null or empty");
        this.namespace = StringUtils.requireNotNullOrEmpty(namespace, "Namespace must not be null or empty");
        this.attributes = attributes == null ? Collections.emptyMap() : attributes;
        this.text = text;
        this.elements = elements;
    }

    @Override
    public String getElementName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public String getAttributeValue(String attribute) {
        return this.attributes.get(attribute);
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public StandardExtensionElement getFirstElement(String element, String namespace) {
        if (this.elements == null) {
            return null;
        }
        String key = XmppStringUtils.generateKey(element, namespace);
        return this.elements.getFirst(key);
    }

    public StandardExtensionElement getFirstElement(String element) {
        return this.getFirstElement(element, this.namespace);
    }

    public List<StandardExtensionElement> getElements(String element, String namespace) {
        if (this.elements == null) {
            return null;
        }
        String key = XmppStringUtils.generateKey(element, namespace);
        return this.elements.getAll(key);
    }

    public List<StandardExtensionElement> getElements(String element) {
        return this.getElements(element, this.namespace);
    }

    public List<StandardExtensionElement> getElements() {
        if (this.elements == null) {
            return Collections.emptyList();
        }
        return this.elements.values();
    }

    public String getText() {
        return this.text;
    }

    @Override
    public XmlStringBuilder toXML(String enclosingNamespace) {
        if (this.xmlCache != null) {
            return this.xmlCache;
        }
        XmlStringBuilder xml = new XmlStringBuilder(this, enclosingNamespace);
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            xml.attribute(entry.getKey(), entry.getValue());
        }
        xml.rightAngleBracket();
        if (this.text != null) {
            xml.text(this.text);
        }
        if (this.elements != null) {
            for (Map.Entry<String, Object> entry : this.elements.entrySet()) {
                xml.append(((StandardExtensionElement)entry.getValue()).toXML(this.getNamespace()));
            }
        }
        xml.closeElement(this);
        this.xmlCache = xml;
        return xml;
    }

    public static Builder builder(String name, String namespace) {
        return new Builder(name, namespace);
    }

    public static final class Builder {
        private final String name;
        private final String namespace;
        private Map<String, String> attributes;
        private String text;
        private MultiMap<String, StandardExtensionElement> elements;

        private Builder(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public Builder addAttribute(String name, String value) {
            StringUtils.requireNotNullOrEmpty(name, "Attribute name must be set");
            Objects.requireNonNull(value, "Attribute value must be not null");
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, String>();
            }
            this.attributes.put(name, value);
            return this;
        }

        public Builder addAttributes(Map<String, String> attributes) {
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, String>(attributes.size());
            }
            this.attributes.putAll(attributes);
            return this;
        }

        public Builder setText(String text) {
            this.text = Objects.requireNonNull(text, "Text must be not null");
            return this;
        }

        public Builder addElement(StandardExtensionElement element) {
            Objects.requireNonNull(element, "Element must not be null");
            if (this.elements == null) {
                this.elements = new MultiMap();
            }
            String key = XmppStringUtils.generateKey(element.getElementName(), element.getNamespace());
            this.elements.put(key, element);
            return this;
        }

        public Builder addElement(String name, String textValue) {
            StandardExtensionElement element = StandardExtensionElement.builder(name, this.namespace).setText(textValue).build();
            return this.addElement(element);
        }

        public StandardExtensionElement build() {
            return new StandardExtensionElement(this.name, this.namespace, this.attributes, this.text, this.elements);
        }
    }
}

