/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.jivesoftware.smack.proxy.ProxyException;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.proxy.ProxySocketConnection;

public class Socks5ProxySocketConnection
implements ProxySocketConnection {
    private final ProxyInfo proxy;

    Socks5ProxySocketConnection(ProxyInfo proxy) {
        this.proxy = proxy;
    }

    @Override
    public void connect(Socket socket, String host, int port, int timeout) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        String proxy_host = this.proxy.getProxyAddress();
        int proxy_port = this.proxy.getProxyPort();
        String user = this.proxy.getProxyUsername();
        String passwd = this.proxy.getProxyPassword();
        try {
            socket.connect(new InetSocketAddress(proxy_host, proxy_port), timeout);
            in = socket.getInputStream();
            out = socket.getOutputStream();
            socket.setTcpNoDelay(true);
            byte[] buf = new byte[1024];
            int index = 0;
            buf[index++] = 5;
            buf[index++] = 2;
            buf[index++] = 0;
            buf[index++] = 2;
            out.write(buf, 0, index);
            Socks5ProxySocketConnection.fill(in, buf, 2);
            boolean check = false;
            switch (buf[1] & 0xFF) {
                case 0: {
                    check = true;
                    break;
                }
                case 2: {
                    if (user == null || passwd == null) break;
                    index = 0;
                    buf[index++] = 1;
                    buf[index++] = (byte)user.length();
                    byte[] userBytes = user.getBytes("UTF-8");
                    System.arraycopy(userBytes, 0, buf, index, user.length());
                    index += user.length();
                    byte[] passwordBytes = passwd.getBytes("UTF-8");
                    buf[index++] = (byte)passwordBytes.length;
                    System.arraycopy(passwordBytes, 0, buf, index, passwd.length());
                    out.write(buf, 0, index += passwd.length());
                    Socks5ProxySocketConnection.fill(in, buf, 2);
                    if (buf[1] != 0) break;
                    check = true;
                    break;
                }
            }
            if (!check) {
                try {
                    socket.close();
                }
                catch (Exception userBytes) {
                    // empty catch block
                }
                throw new ProxyException(ProxyInfo.ProxyType.SOCKS5, "fail in SOCKS5 proxy");
            }
            index = 0;
            buf[index++] = 5;
            buf[index++] = 1;
            buf[index++] = 0;
            byte[] hostb = host.getBytes("UTF-8");
            int len = hostb.length;
            buf[index++] = 3;
            buf[index++] = (byte)len;
            System.arraycopy(hostb, 0, buf, index, len);
            index += len;
            buf[index++] = (byte)(port >>> 8);
            buf[index++] = (byte)(port & 0xFF);
            out.write(buf, 0, index);
            Socks5ProxySocketConnection.fill(in, buf, 4);
            if (buf[1] != 0) {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ProxyException(ProxyInfo.ProxyType.SOCKS5, "server returns " + buf[1]);
            }
            switch (buf[3] & 0xFF) {
                case 1: {
                    Socks5ProxySocketConnection.fill(in, buf, 6);
                    break;
                }
                case 3: {
                    Socks5ProxySocketConnection.fill(in, buf, 1);
                    Socks5ProxySocketConnection.fill(in, buf, (buf[0] & 0xFF) + 2);
                    break;
                }
                case 4: {
                    Socks5ProxySocketConnection.fill(in, buf, 18);
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException(e.getLocalizedMessage());
        }
    }

    private static void fill(InputStream in, byte[] buf, int len) throws IOException {
        int i;
        for (int s = 0; s < len; s += i) {
            i = in.read(buf, s, len - s);
            if (i > 0) continue;
            throw new ProxyException(ProxyInfo.ProxyType.SOCKS5, "stream is closed");
        }
    }
}

