/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sm.predicates;

import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.util.StringUtils;

public final class OnceForThisStanza
implements StanzaFilter {
    private final String id;
    private final XMPPTCPConnection connection;

    public static void setup(XMPPTCPConnection connection, Stanza packet) {
        OnceForThisStanza packetFilter = new OnceForThisStanza(connection, packet);
        connection.addRequestAckPredicate(packetFilter);
    }

    private OnceForThisStanza(XMPPTCPConnection connection, Stanza packet) {
        this.connection = connection;
        this.id = packet.getStanzaId();
        if (StringUtils.isNullOrEmpty((CharSequence)this.id)) {
            throw new IllegalArgumentException("Stanza ID must be set");
        }
    }

    @Override
    public boolean accept(Stanza packet) {
        String otherId = packet.getStanzaId();
        if (StringUtils.isNullOrEmpty((CharSequence)otherId)) {
            return false;
        }
        if (this.id.equals(otherId)) {
            this.connection.removeRequestAckPredicate(this);
            return true;
        }
        return false;
    }
}

