/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.TypedCloneable;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jxmpp.util.XmppStringUtils;

public class DiscoverInfo
extends IQ
implements TypedCloneable<DiscoverInfo> {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "http://jabber.org/protocol/disco#info";
    private final List<Feature> features = new LinkedList<Feature>();
    private final Set<Feature> featuresSet = new HashSet<Feature>();
    private final List<Identity> identities = new LinkedList<Identity>();
    private final Set<String> identitiesSet = new HashSet<String>();
    private String node;
    private boolean containsDuplicateFeatures;

    public DiscoverInfo() {
        super(ELEMENT, NAMESPACE);
    }

    public DiscoverInfo(DiscoverInfo d) {
        super(d);
        this.setNode(d.getNode());
        for (Feature f : d.features) {
            this.addFeature(f.clone());
        }
        for (Identity i : d.identities) {
            this.addIdentity(i.clone());
        }
    }

    public boolean addFeature(String feature) {
        return this.addFeature(new Feature(feature));
    }

    public void addFeatures(Collection<String> featuresToAdd) {
        if (featuresToAdd == null) {
            return;
        }
        for (String feature : featuresToAdd) {
            this.addFeature(feature);
        }
    }

    public boolean addFeature(Feature feature) {
        this.features.add(feature);
        boolean featureIsNew = this.featuresSet.add(feature);
        if (!featureIsNew) {
            this.containsDuplicateFeatures = true;
        }
        return featureIsNew;
    }

    public List<Feature> getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    public void addIdentity(Identity identity) {
        this.identities.add(identity);
        this.identitiesSet.add(identity.getKey());
    }

    public void addIdentities(Collection<Identity> identitiesToAdd) {
        if (identitiesToAdd == null) {
            return;
        }
        for (Identity identity : identitiesToAdd) {
            this.addIdentity(identity);
        }
    }

    public List<Identity> getIdentities() {
        return Collections.unmodifiableList(this.identities);
    }

    public boolean hasIdentity(String category, String type) {
        String key = XmppStringUtils.generateKey(category, type);
        return this.identitiesSet.contains(key);
    }

    public List<Identity> getIdentities(String category, String type) {
        ArrayList<Identity> res = new ArrayList<Identity>(this.identities.size());
        for (Identity identity : this.identities) {
            if (!identity.getCategory().equals(category) || !identity.getType().equals(type)) continue;
            res.add(identity);
        }
        return res;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public boolean containsFeature(CharSequence feature) {
        return this.features.contains(new Feature(feature));
    }

    @Override
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        xml.optAttribute("node", this.getNode());
        xml.rightAngleBracket();
        for (Identity identity : this.identities) {
            xml.append(identity.toXML());
        }
        for (Feature feature : this.features) {
            xml.append(feature.toXML());
        }
        return xml;
    }

    public boolean containsDuplicateIdentities() {
        LinkedList<Identity> checkedIdentities = new LinkedList<Identity>();
        for (Identity i : this.identities) {
            for (Identity i2 : checkedIdentities) {
                if (!i.equals(i2)) continue;
                return true;
            }
            checkedIdentities.add(i);
        }
        return false;
    }

    public boolean containsDuplicateFeatures() {
        return this.containsDuplicateFeatures;
    }

    @Override
    public DiscoverInfo clone() {
        return new DiscoverInfo(this);
    }

    public static class Feature
    implements TypedCloneable<Feature> {
        private final String variable;

        public Feature(Feature feature) {
            this.variable = feature.variable;
        }

        public Feature(CharSequence variable) {
            this(variable.toString());
        }

        public Feature(String variable) {
            this.variable = StringUtils.requireNotNullOrEmpty(variable, "variable cannot be null");
        }

        public String getVar() {
            return this.variable;
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement("feature");
            xml.attribute("var", this.variable);
            xml.closeEmptyElement();
            return xml;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Feature other = (Feature)obj;
            return this.variable.equals(other.variable);
        }

        public int hashCode() {
            return this.variable.hashCode();
        }

        @Override
        public Feature clone() {
            return new Feature(this);
        }

        public String toString() {
            return this.toXML().toString();
        }
    }

    public static class Identity
    implements Comparable<Identity>,
    TypedCloneable<Identity> {
        private final String category;
        private final String type;
        private final String key;
        private final String name;
        private final String lang;

        public Identity(Identity identity) {
            this.category = identity.category;
            this.type = identity.type;
            this.key = identity.type;
            this.name = identity.name;
            this.lang = identity.lang;
        }

        public Identity(String category, String type) {
            this(category, type, null, null);
        }

        public Identity(String category, String name, String type) {
            this(category, type, name, null);
        }

        public Identity(String category, String type, String name, String lang) {
            this.category = StringUtils.requireNotNullOrEmpty(category, "category cannot be null");
            this.type = StringUtils.requireNotNullOrEmpty(type, "type cannot be null");
            this.key = XmppStringUtils.generateKey(category, type);
            this.name = name;
            this.lang = lang;
        }

        public String getCategory() {
            return this.category;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getLanguage() {
            return this.lang;
        }

        private String getKey() {
            return this.key;
        }

        public boolean isOfCategoryAndType(String category, String type) {
            return this.category.equals(category) && this.type.equals(type);
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement("identity");
            xml.xmllangAttribute(this.lang);
            xml.attribute("category", this.category);
            xml.optAttribute("name", this.name);
            xml.optAttribute("type", this.type);
            xml.closeEmptyElement();
            return xml;
        }

        public boolean equals(Object obj) {
            String thisName;
            String thisLang;
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Identity other = (Identity)obj;
            if (!this.key.equals(other.key)) {
                return false;
            }
            String otherLang = other.lang == null ? "" : other.lang;
            String string = thisLang = this.lang == null ? "" : this.lang;
            if (!otherLang.equals(thisLang)) {
                return false;
            }
            String otherName = other.name == null ? "" : other.name;
            String string2 = thisName = this.name == null ? "" : other.name;
            return thisName.equals(otherName);
        }

        public int hashCode() {
            int result = 1;
            result = 37 * result + this.key.hashCode();
            result = 37 * result + (this.lang == null ? 0 : this.lang.hashCode());
            result = 37 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        @Override
        public int compareTo(Identity other) {
            String thisType;
            String otherLang = other.lang == null ? "" : other.lang;
            String thisLang = this.lang == null ? "" : this.lang;
            String otherType = other.type == null ? "" : other.type;
            String string = thisType = this.type == null ? "" : this.type;
            if (this.category.equals(other.category)) {
                if (thisType.equals(otherType)) {
                    if (thisLang.equals(otherLang)) {
                        return 0;
                    }
                    return thisLang.compareTo(otherLang);
                }
                return thisType.compareTo(otherType);
            }
            return this.category.compareTo(other.category);
        }

        @Override
        public Identity clone() {
            return new Identity(this);
        }

        public String toString() {
            return this.toXML().toString();
        }
    }
}

