/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.jingle.element.JingleContentTransport;
import org.jivesoftware.smackx.jingle.element.JingleContentTransportCandidate;
import org.jivesoftware.smackx.jingle.element.JingleContentTransportInfo;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransportCandidate;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransportInfo;

public class JingleS5BTransport
extends JingleContentTransport {
    public static final String NAMESPACE_V1 = "urn:xmpp:jingle:transports:s5b:1";
    public static final String ATTR_DSTADDR = "dstaddr";
    public static final String ATTR_MODE = "mode";
    public static final String ATTR_SID = "sid";
    private final String streamId;
    private final String dstAddr;
    private final Bytestream.Mode mode;

    protected JingleS5BTransport(List<JingleContentTransportCandidate> candidates, JingleContentTransportInfo info, String streamId, String dstAddr, Bytestream.Mode mode) {
        super(candidates, info);
        StringUtils.requireNotNullOrEmpty(streamId, "sid MUST be neither null, nor empty.");
        this.streamId = streamId;
        this.dstAddr = dstAddr;
        this.mode = mode;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public String getDestinationAddress() {
        return this.dstAddr;
    }

    public Bytestream.Mode getMode() {
        return this.mode == null ? Bytestream.Mode.tcp : this.mode;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE_V1;
    }

    @Override
    protected void addExtraAttributes(XmlStringBuilder xml) {
        xml.optAttribute(ATTR_DSTADDR, this.dstAddr);
        xml.optAttribute(ATTR_MODE, this.mode);
        xml.attribute(ATTR_SID, this.streamId);
    }

    public boolean hasCandidate(String candidateId) {
        return this.getCandidate(candidateId) != null;
    }

    public JingleS5BTransportCandidate getCandidate(String candidateId) {
        for (JingleContentTransportCandidate c : this.candidates) {
            JingleS5BTransportCandidate candidate = (JingleS5BTransportCandidate)c;
            if (!candidate.getCandidateId().equals(candidateId)) continue;
            return candidate;
        }
        return null;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String streamId;
        private String dstAddr;
        private Bytestream.Mode mode;
        private final ArrayList<JingleContentTransportCandidate> candidates = new ArrayList();
        private JingleContentTransportInfo info;

        public Builder setStreamId(String sid) {
            this.streamId = sid;
            return this;
        }

        public Builder setDestinationAddress(String dstAddr) {
            this.dstAddr = dstAddr;
            return this;
        }

        public Builder setMode(Bytestream.Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder addTransportCandidate(JingleS5BTransportCandidate candidate) {
            if (this.info != null) {
                throw new IllegalStateException("Builder has already an info set. The transport can only have either an info or transport candidates, not both.");
            }
            this.candidates.add(candidate);
            return this;
        }

        public Builder setTransportInfo(JingleContentTransportInfo info) {
            if (!this.candidates.isEmpty()) {
                throw new IllegalStateException("Builder has already at least one candidate set. The transport can only have either an info or transport candidates, not both.");
            }
            if (this.info != null) {
                throw new IllegalStateException("Builder has already an info set.");
            }
            this.info = info;
            return this;
        }

        public Builder setCandidateUsed(String candidateId) {
            return this.setTransportInfo(new JingleS5BTransportInfo.CandidateUsed(candidateId));
        }

        public Builder setCandidateActivated(String candidateId) {
            return this.setTransportInfo(new JingleS5BTransportInfo.CandidateActivated(candidateId));
        }

        public Builder setCandidateError() {
            return this.setTransportInfo(JingleS5BTransportInfo.CandidateError.INSTANCE);
        }

        public Builder setProxyError() {
            return this.setTransportInfo(JingleS5BTransportInfo.ProxyError.INSTANCE);
        }

        public JingleS5BTransport build() {
            return new JingleS5BTransport(this.candidates, this.info, this.streamId, this.dstAddr, this.mode);
        }
    }
}

