/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.component.xmpp.XmppMessage;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.URISupport;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.chat2.Chat;
import org.jivesoftware.smack.chat2.ChatManager;
import org.jivesoftware.smack.chat2.IncomingChatMessageListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smackx.muc.MucEnterConfiguration;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmppConsumer
extends DefaultConsumer
implements IncomingChatMessageListener,
MessageListener,
StanzaListener {
    private static final Logger LOG = LoggerFactory.getLogger(XmppConsumer.class);
    private final XmppEndpoint endpoint;
    private MultiUserChat muc;
    private ChatManager chatManager;
    private XMPPTCPConnection connection;
    private ScheduledExecutorService scheduledExecutor;

    public XmppConsumer(XmppEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    @Override
    protected void doStart() throws Exception {
        try {
            this.connection = this.endpoint.createConnection();
        }
        catch (SmackException e) {
            if (this.endpoint.isTestConnectionOnStartup()) {
                throw new RuntimeCamelException("Could not connect to XMPP server.", e);
            }
            LOG.warn(e.getMessage());
            if (this.getExceptionHandler() != null) {
                this.getExceptionHandler().handleException(e.getMessage(), e);
            }
            this.scheduleDelayedStart();
            return;
        }
        this.chatManager = ChatManager.getInstanceFor(this.connection);
        this.chatManager.addIncomingListener(this);
        OrFilter pubsubPacketFilter = new OrFilter();
        if (this.endpoint.isPubsub()) {
            pubsubPacketFilter.addFilter(MessageTypeFilter.HEADLINE);
            pubsubPacketFilter.addFilter(MessageTypeFilter.NORMAL);
            this.connection.addSyncStanzaListener(this, pubsubPacketFilter);
        }
        if (this.endpoint.getRoom() == null) {
            this.chatManager.chatWith(JidCreate.entityBareFrom(this.endpoint.resolveParticipant(this.connection)));
        } else {
            AndFilter packetFilter = new AndFilter(new StanzaTypeFilter(Presence.class));
            this.connection.addSyncStanzaListener(this, packetFilter);
            String roomPassword = this.endpoint.getRoomPassword();
            MultiUserChatManager mucm = MultiUserChatManager.getInstanceFor(this.connection);
            this.muc = mucm.getMultiUserChat(JidCreate.entityBareFrom(this.endpoint.resolveRoom(this.connection)));
            this.muc.addMessageListener(this);
            MucEnterConfiguration.Builder mucc = this.muc.getEnterConfigurationBuilder(Resourcepart.from(this.endpoint.getNickname())).requestNoHistory();
            if (roomPassword != null) {
                mucc.withPassword(roomPassword);
            }
            this.muc.join(mucc.build());
            LOG.info("Joined room: {} as: {}", (Object)this.muc.getRoom(), (Object)this.endpoint.getNickname());
        }
        this.startRobustConnectionMonitor();
        super.doStart();
    }

    protected void scheduleDelayedStart() {
        Runnable startRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    XmppConsumer.this.doStart();
                }
                catch (Exception e) {
                    LOG.warn("Ignoring an exception caught in the startup connection poller thread.", (Throwable)e);
                }
            }
        };
        LOG.info("Delaying XMPP consumer startup for endpoint {}. Trying again in {} seconds.", (Object)URISupport.sanitizeUri(this.endpoint.getEndpointUri()), (Object)this.endpoint.getConnectionPollDelay());
        this.getExecutor().schedule(startRunnable, (long)this.endpoint.getConnectionPollDelay(), TimeUnit.SECONDS);
    }

    private void startRobustConnectionMonitor() {
        Runnable connectionCheckRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    XmppConsumer.this.checkConnection();
                }
                catch (Exception e) {
                    LOG.warn("Ignoring an exception caught in the connection poller thread.", (Throwable)e);
                }
            }
        };
        this.getExecutor().scheduleAtFixedRate(connectionCheckRunnable, this.endpoint.getConnectionPollDelay(), this.endpoint.getConnectionPollDelay(), TimeUnit.SECONDS);
    }

    private void checkConnection() throws Exception {
        if (!this.connection.isConnected()) {
            LOG.info("Attempting to reconnect to: {}", (Object)XmppEndpoint.getConnectionMessage(this.connection));
            try {
                this.connection.connect();
                LOG.debug("Successfully connected to XMPP server through: {}", (Object)this.connection);
            }
            catch (SmackException e) {
                LOG.warn("Connection to XMPP server failed. Will try to reconnect later again.", (Throwable)e);
            }
        }
    }

    private ScheduledExecutorService getExecutor() {
        if (this.scheduledExecutor == null) {
            this.scheduledExecutor = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor(this, "connectionPoll");
        }
        return this.scheduledExecutor;
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.scheduledExecutor != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.scheduledExecutor);
            this.scheduledExecutor = null;
        }
        if (this.muc != null) {
            LOG.info("Leaving room: {}", (Object)this.muc.getRoom());
            this.muc.removeMessageListener(this);
            this.muc.leave();
            this.muc = null;
        }
        if (this.connection != null && this.connection.isConnected()) {
            this.connection.disconnect();
        }
    }

    @Override
    public void newIncomingMessage(EntityBareJid from, Message message, Chat chat) {
        this.processMessage(message);
    }

    @Override
    public void processMessage(Message message) {
        this.processMessage(null, message);
    }

    @Override
    public void processStanza(Stanza stanza) throws SmackException.NotConnectedException, InterruptedException {
        if (stanza instanceof Message) {
            this.processMessage((Message)stanza);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(Chat chat, Message message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received XMPP message for {} from {} : {}", new Object[]{this.endpoint.getUser(), this.endpoint.getParticipant(), message.getBody()});
        }
        Exchange exchange = this.createExchange(message);
        try {
            if (this.endpoint.isDoc()) {
                exchange.getIn().setHeader("CamelXmppDoc", message);
            }
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        finally {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, exchange.getException());
            }
            this.releaseExchange(exchange, false);
            if (this.muc != null) {
                try {
                    this.muc.pollMessage();
                }
                catch (MultiUserChatException.MucNotJoinedException e) {
                    LOG.debug("Error while polling message from MultiUserChat. This exception will be ignored.", (Throwable)e);
                }
                catch (Exception exception) {}
            }
        }
    }

    private Exchange createExchange(Stanza packet) {
        Exchange exchange = this.createExchange(false);
        exchange.setProperty("CamelBinding", (Object)this.endpoint.getBinding());
        exchange.setIn(new XmppMessage(exchange, packet));
        return exchange;
    }
}

