/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.java7;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.minidns.util.InetAddressUtil;

public class XmppHostnameVerifier
implements HostnameVerifier {
    private static final Logger LOGGER = Logger.getLogger(XmppHostnameVerifier.class.getName());
    private static final int ALTNAME_DNS = 2;
    private static final int ALTNAME_IP = 7;

    @Override
    public boolean verify(String hostname, SSLSession session) {
        boolean validCertificate = false;
        boolean validPrincipal = false;
        try {
            Certificate[] peerCertificates = session.getPeerCertificates();
            if (peerCertificates.length == 0) {
                return false;
            }
            if (!(peerCertificates[0] instanceof X509Certificate)) {
                return false;
            }
            X509Certificate peerCertificate = (X509Certificate)peerCertificates[0];
            try {
                XmppHostnameVerifier.match(hostname, peerCertificate);
                validCertificate = true;
            }
            catch (CertificateException e) {
                LOGGER.log(Level.INFO, "Certificate does not match hostname", e);
            }
        }
        catch (SSLPeerUnverifiedException e) {
            Principal peerPrincipal = null;
            try {
                peerPrincipal = session.getPeerPrincipal();
            }
            catch (SSLPeerUnverifiedException e2) {
                LOGGER.log(Level.INFO, "Can't verify principal for " + hostname + ". Not kerberos", e2);
            }
            if (peerPrincipal instanceof KerberosPrincipal) {
                validPrincipal = XmppHostnameVerifier.match(hostname, (KerberosPrincipal)peerPrincipal);
            }
            LOGGER.info("Can't verify principal for " + hostname + ". Not kerberos");
        }
        return validCertificate || validPrincipal;
    }

    private static void match(String name, X509Certificate cert) throws CertificateException {
        if (InetAddressUtil.isIpAddress(name)) {
            XmppHostnameVerifier.matchIp(name, cert);
        } else {
            XmppHostnameVerifier.matchDns(name, cert);
        }
    }

    private static boolean match(String name, KerberosPrincipal peerPrincipal) {
        LOGGER.warning("KerberosPrincipal validation not implemented yet. Can not verify " + name);
        return false;
    }

    private static void matchDns(String name, X509Certificate cert) throws CertificateException {
        Collection<List<?>> subjAltNames = cert.getSubjectAlternativeNames();
        if (subjAltNames != null) {
            LinkedList<String> nonMatchingDnsAltnames = new LinkedList<String>();
            for (List<?> san : subjAltNames) {
                if ((Integer)san.get(0) != 2) continue;
                String dnsName = (String)san.get(1);
                if (XmppHostnameVerifier.matchesPerRfc2818(name, dnsName)) {
                    return;
                }
                nonMatchingDnsAltnames.add(dnsName);
            }
            if (!nonMatchingDnsAltnames.isEmpty()) {
                StringBuilder sb = new StringBuilder("No subject alternative DNS name matching " + name + " found. Tried: ");
                for (String nonMatchingDnsAltname : nonMatchingDnsAltnames) {
                    sb.append(nonMatchingDnsAltname).append(',');
                }
                throw new CertificateException(sb.toString());
            }
        }
        LdapName dn = null;
        try {
            dn = new LdapName(cert.getSubjectX500Principal().getName());
        }
        catch (InvalidNameException e) {
            LOGGER.warning("Invalid DN: " + e.getMessage());
        }
        if (dn != null) {
            for (Rdn rdn : dn.getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                if (!XmppHostnameVerifier.matchesPerRfc2818(name, rdn.getValue().toString())) break;
                return;
            }
        }
        throw new CertificateException("No name matching " + name + " found");
    }

    private static boolean matchesPerRfc2818(String name, String template) {
        String[] templateParts;
        String[] nameParts = name.toLowerCase(Locale.US).split("\\.");
        if (nameParts.length != (templateParts = template.toLowerCase(Locale.US).split("\\.")).length) {
            return false;
        }
        for (int i = 0; i < nameParts.length; ++i) {
            if (XmppHostnameVerifier.matchWildCards(nameParts[i], templateParts[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean matchWildCards(String name, String template) {
        int wildcardIndex = template.indexOf("*");
        if (wildcardIndex == -1) {
            return name.equals(template);
        }
        boolean isBeginning = true;
        String afterWildcard = template;
        while (wildcardIndex != -1) {
            String beforeWildcard = afterWildcard.substring(0, wildcardIndex);
            afterWildcard = afterWildcard.substring(wildcardIndex + 1);
            int beforeStartIndex = name.indexOf(beforeWildcard);
            if (beforeStartIndex == -1 || isBeginning && beforeStartIndex != 0) {
                return false;
            }
            isBeginning = false;
            name = name.substring(beforeStartIndex + beforeWildcard.length());
            wildcardIndex = afterWildcard.indexOf("*");
        }
        return name.endsWith(afterWildcard);
    }

    private static void matchIp(String expectedIP, X509Certificate cert) throws CertificateException {
        Collection<List<?>> subjectAlternativeNames = cert.getSubjectAlternativeNames();
        if (subjectAlternativeNames == null) {
            throw new CertificateException("No subject alternative names present");
        }
        LinkedList<String> nonMatchingIpAltnames = new LinkedList<String>();
        for (List<?> san : subjectAlternativeNames) {
            if ((Integer)san.get(0) != 7) continue;
            String ipAddress = (String)san.get(1);
            if (expectedIP.equalsIgnoreCase(ipAddress)) {
                return;
            }
            try {
                if (InetAddress.getByName(expectedIP).equals(InetAddress.getByName(ipAddress))) {
                    return;
                }
            }
            catch (SecurityException | UnknownHostException e) {
                LOGGER.log(Level.FINE, "Comparing IP strings failed", e);
            }
            nonMatchingIpAltnames.add(ipAddress);
        }
        StringBuilder sb = new StringBuilder("No subject alternative names matching IP address " + expectedIP + " found. Tried: ");
        for (String s : nonMatchingIpAltnames) {
            sb.append(s).append(',');
        }
        throw new CertificateException(sb.toString());
    }
}

