/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster.provider;

import java.io.IOException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.util.ParserUtils;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RosterPacketProvider
extends IQProvider<RosterPacket> {
    public static final RosterPacketProvider INSTANCE = new RosterPacketProvider();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public RosterPacket parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackException {
        RosterPacket roster = new RosterPacket();
        String version = parser.getAttributeValue("", "ver");
        roster.setVersion(version);
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String startTag;
                    switch (startTag = parser.getName()) {
                        case "item": {
                            RosterPacket.Item item = RosterPacketProvider.parseItem(parser);
                            roster.addRosterItem(item);
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    String endTag;
                    switch (endTag = parser.getName()) {
                        case "query": {
                            if (parser.getDepth() != initialDepth) break block0;
                            return roster;
                        }
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static RosterPacket.Item parseItem(XmlPullParser parser) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag(parser, "item");
        int initialDepth = parser.getDepth();
        String jidString = parser.getAttributeValue("", "jid");
        String itemName = parser.getAttributeValue("", "name");
        BareJid jid = JidCreate.bareFrom(jidString);
        RosterPacket.Item item = new RosterPacket.Item(jid, itemName);
        String ask = parser.getAttributeValue("", "ask");
        item.setSubscriptionPending("subscribe".equals(ask));
        String subscription = parser.getAttributeValue("", "subscription");
        RosterPacket.ItemType type = RosterPacket.ItemType.fromString(subscription);
        item.setItemType(type);
        boolean approved = ParserUtils.getBooleanAttribute(parser, "approved", false);
        item.setApproved(approved);
        block10: while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name;
                    switch (name = parser.getName()) {
                        case "group": {
                            String groupName = parser.nextText();
                            if (groupName != null && groupName.trim().length() > 0) {
                                item.addGroupName(groupName);
                                break;
                            }
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() == initialDepth) break block10;
                }
            }
        }
        ParserUtils.assertAtEndTag(parser);
        assert (item != null);
        return item;
    }
}

