/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl.core;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.security.auth.callback.CallbackHandler;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.sasl.core.ScramHmac;
import org.jivesoftware.smack.util.ByteUtils;
import org.jivesoftware.smack.util.SHA1;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jxmpp.util.cache.Cache;
import org.jxmpp.util.cache.LruCache;

public abstract class ScramMechanism
extends SASLMechanism {
    private static final int RANDOM_ASCII_BYTE_COUNT = 32;
    private static final byte[] CLIENT_KEY_BYTES = ScramMechanism.toBytes("Client Key");
    private static final byte[] SERVER_KEY_BYTES = ScramMechanism.toBytes("Server Key");
    private static final byte[] ONE = new byte[]{0, 0, 0, 1};
    private static final ThreadLocal<SecureRandom> SECURE_RANDOM = new ThreadLocal<SecureRandom>(){

        @Override
        protected SecureRandom initialValue() {
            return new SecureRandom();
        }
    };
    private static final Cache<String, Keys> CACHE = new LruCache<String, Keys>(10);
    private final ScramHmac scramHmac;
    private State state = State.INITIAL;
    private String clientRandomAscii;
    private String clientFirstMessageBare;
    private byte[] serverSignature;

    protected ScramMechanism(ScramHmac scramHmac) {
        this.scramHmac = scramHmac;
    }

    @Override
    protected void authenticateInternal(CallbackHandler cbh) throws SmackException {
        throw new UnsupportedOperationException("CallbackHandler not (yet) supported");
    }

    @Override
    protected byte[] getAuthenticationText() throws SmackException {
        this.clientRandomAscii = this.getRandomAscii();
        String saslPrepedAuthcId = ScramMechanism.saslPrep(this.authenticationId);
        this.clientFirstMessageBare = "n=" + ScramMechanism.escape(saslPrepedAuthcId) + ",r=" + this.clientRandomAscii;
        String clientFirstMessage = this.getGS2Header() + this.clientFirstMessageBare;
        this.state = State.AUTH_TEXT_SENT;
        return ScramMechanism.toBytes(clientFirstMessage);
    }

    @Override
    public String getName() {
        String name = "SCRAM-" + this.scramHmac.getHmacName();
        return name;
    }

    @Override
    public void checkIfSuccessfulOrThrow() throws SmackException {
        if (this.state != State.VALID_SERVER_RESPONSE) {
            throw new SmackException("SCRAM-SHA1 is missing valid server response");
        }
    }

    @Override
    public boolean authzidSupported() {
        return true;
    }

    @Override
    protected byte[] evaluateChallenge(byte[] challenge) throws SmackException {
        String challengeString;
        try {
            challengeString = new String(challenge, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        switch (this.state) {
            case AUTH_TEXT_SENT: {
                byte[] clientKey;
                byte[] serverKey;
                int iterations;
                String serverFirstMessage = challengeString;
                Map<Character, String> attributes = ScramMechanism.parseAttributes(challengeString);
                String rvalue = attributes.get(Character.valueOf('r'));
                if (rvalue == null) {
                    throw new SmackException("Server random ASCII is null");
                }
                if (rvalue.length() <= this.clientRandomAscii.length()) {
                    throw new SmackException("Server random ASCII is shorter then client random ASCII");
                }
                String receivedClientRandomAscii = rvalue.substring(0, this.clientRandomAscii.length());
                if (!receivedClientRandomAscii.equals(this.clientRandomAscii)) {
                    throw new SmackException("Received client random ASCII does not match client random ASCII");
                }
                String iterationsString = attributes.get(Character.valueOf('i'));
                if (iterationsString == null) {
                    throw new SmackException("Iterations attribute not set");
                }
                try {
                    iterations = Integer.parseInt(iterationsString);
                }
                catch (NumberFormatException e) {
                    throw new SmackException("Exception parsing iterations", e);
                }
                String salt = attributes.get(Character.valueOf('s'));
                if (salt == null) {
                    throw new SmackException("SALT not send");
                }
                String channelBinding = "c=" + Base64.encodeToString(this.getCBindInput());
                String clientFinalMessageWithoutProof = channelBinding + ",r=" + rvalue;
                byte[] authMessage = ScramMechanism.toBytes(this.clientFirstMessageBare + ',' + serverFirstMessage + ',' + clientFinalMessageWithoutProof);
                String cacheKey = this.password + ',' + salt + ',' + this.getName();
                Keys keys = CACHE.lookup(cacheKey);
                if (keys == null) {
                    byte[] saltedPassword = this.hi(ScramMechanism.saslPrep(this.password), Base64.decode(salt), iterations);
                    serverKey = this.hmac(saltedPassword, SERVER_KEY_BYTES);
                    clientKey = this.hmac(saltedPassword, CLIENT_KEY_BYTES);
                    keys = new Keys(clientKey, serverKey);
                    CACHE.put(cacheKey, keys);
                } else {
                    serverKey = keys.serverKey;
                    clientKey = keys.clientKey;
                }
                this.serverSignature = this.hmac(serverKey, authMessage);
                byte[] storedKey = SHA1.bytes(clientKey);
                byte[] clientSignature = this.hmac(storedKey, authMessage);
                byte[] clientProof = new byte[clientKey.length];
                for (int i = 0; i < clientProof.length; ++i) {
                    clientProof[i] = (byte)(clientKey[i] ^ clientSignature[i]);
                }
                String clientFinalMessage = clientFinalMessageWithoutProof + ",p=" + Base64.encodeToString(clientProof);
                this.state = State.RESPONSE_SENT;
                return ScramMechanism.toBytes(clientFinalMessage);
            }
            case RESPONSE_SENT: {
                String clientCalculatedServerFinalMessage = "v=" + Base64.encodeToString(this.serverSignature);
                if (!clientCalculatedServerFinalMessage.equals(challengeString)) {
                    throw new SmackException("Server final message does not match calculated one");
                }
                this.state = State.VALID_SERVER_RESPONSE;
                break;
            }
            default: {
                throw new SmackException("Invalid state");
            }
        }
        return null;
    }

    private String getGS2Header() {
        String authzidPortion = "";
        if (this.authorizationId != null) {
            authzidPortion = "a=" + this.authorizationId;
        }
        String cbName = this.getChannelBindingName();
        assert (StringUtils.isNotEmpty((CharSequence)cbName));
        return cbName + ',' + authzidPortion + ",";
    }

    private byte[] getCBindInput() throws SmackException {
        byte[] cbindData = this.getChannelBindingData();
        byte[] gs2Header = ScramMechanism.toBytes(this.getGS2Header());
        if (cbindData == null) {
            return gs2Header;
        }
        return ByteUtils.concat(gs2Header, cbindData);
    }

    protected String getChannelBindingName() {
        if (this.sslSession != null && this.connectionConfiguration.isEnabledSaslMechanism(this.getName() + "-PLUS")) {
            return "y";
        }
        return "n";
    }

    protected byte[] getChannelBindingData() throws SmackException {
        return null;
    }

    private static Map<Character, String> parseAttributes(String string) throws SmackException {
        if (string.length() == 0) {
            return Collections.emptyMap();
        }
        String[] keyValuePairs = string.split(",");
        HashMap<Character, String> res = new HashMap<Character, String>(keyValuePairs.length, 1.0f);
        for (String keyValuePair : keyValuePairs) {
            if (keyValuePair.length() < 3) {
                throw new SmackException("Invalid Key-Value pair: " + keyValuePair);
            }
            char key = keyValuePair.charAt(0);
            if (keyValuePair.charAt(1) != '=') {
                throw new SmackException("Invalid Key-Value pair: " + keyValuePair);
            }
            String value = keyValuePair.substring(2);
            res.put(Character.valueOf(key), value);
        }
        return res;
    }

    String getRandomAscii() {
        int count = 0;
        char[] randomAscii = new char[32];
        Random random = SECURE_RANDOM.get();
        while (count < 32) {
            int r = random.nextInt(128);
            char c = (char)r;
            if (!ScramMechanism.isPrintableNonCommaAsciiChar(c)) continue;
            randomAscii[count++] = c;
        }
        return new String(randomAscii);
    }

    private static boolean isPrintableNonCommaAsciiChar(char c) {
        if (c == ',') {
            return false;
        }
        return c > ' ' && c < '\u007f';
    }

    private static String escape(String string) {
        StringBuilder sb = new StringBuilder((int)((double)string.length() * 1.1));
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ',': {
                    sb.append("=2C");
                    continue block4;
                }
                case '=': {
                    sb.append("=3D");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private byte[] hmac(byte[] key, byte[] str) throws SmackException {
        try {
            return this.scramHmac.hmac(key, str);
        }
        catch (InvalidKeyException e) {
            throw new SmackException(this.getName() + " Exception", e);
        }
    }

    private byte[] hi(String normalizedPassword, byte[] salt, int iterations) throws SmackException {
        byte[] key;
        try {
            key = normalizedPassword.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError();
        }
        byte[] u = this.hmac(key, ByteUtils.concat(salt, ONE));
        byte[] res = (byte[])u.clone();
        for (int i = 1; i < iterations; ++i) {
            u = this.hmac(key, u);
            for (int j = 0; j < u.length; ++j) {
                int n = j;
                res[n] = (byte)(res[n] ^ u[j]);
            }
        }
        return res;
    }

    private static class Keys {
        private final byte[] clientKey;
        private final byte[] serverKey;

        Keys(byte[] clientKey, byte[] serverKey) {
            this.clientKey = clientKey;
            this.serverKey = serverKey;
        }
    }

    private static enum State {
        INITIAL,
        AUTH_TEXT_SENT,
        RESPONSE_SENT,
        VALID_SERVER_RESPONSE;

    }
}

