/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.stringencoder.java7;

import java.io.UnsupportedEncodingException;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smack.util.stringencoder.java7.Base64;

public final class Java7Base64Encoder
implements Base64.Encoder {
    private static final Java7Base64Encoder instance = new Java7Base64Encoder();
    private static final int BASE64_ENCODER_FLAGS = 8;

    private Java7Base64Encoder() {
    }

    public static Java7Base64Encoder getInstance() {
        return instance;
    }

    @Override
    public byte[] decode(String string) {
        return Base64.decode(string);
    }

    @Override
    public byte[] decode(byte[] input, int offset, int len) {
        return Base64.decode(input, offset, len, 0);
    }

    @Override
    public String encodeToString(byte[] input, int offset, int len) {
        return Base64.encodeBytes(input, offset, len, 8);
    }

    @Override
    public byte[] encode(byte[] input, int offset, int len) {
        String string = this.encodeToString(input, offset, len);
        try {
            return string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

