/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jxmpp.jid.Jid;

public class Subscription
extends NodeExtension {
    protected Jid jid;
    protected String id;
    protected State state;
    protected boolean configRequired = false;

    public Subscription(Jid subscriptionJid) {
        this(subscriptionJid, null, null, null);
    }

    public Subscription(Jid subscriptionJid, String nodeId) {
        this(subscriptionJid, nodeId, null, null);
    }

    public Subscription(Jid subscriptionJid, State state) {
        this(subscriptionJid, null, null, state);
    }

    public Subscription(Jid jid, String nodeId, String subscriptionId, State state) {
        super(PubSubElementType.SUBSCRIPTION, nodeId);
        this.jid = jid;
        this.id = subscriptionId;
        this.state = state;
    }

    public Subscription(Jid jid, String nodeId, String subscriptionId, State state, boolean configRequired) {
        super(PubSubElementType.SUBSCRIPTION, nodeId);
        this.jid = jid;
        this.id = subscriptionId;
        this.state = state;
        this.configRequired = configRequired;
    }

    public Jid getJid() {
        return this.jid;
    }

    public String getId() {
        return this.id;
    }

    public State getState() {
        return this.state;
    }

    public boolean isConfigRequired() {
        return this.configRequired;
    }

    @Override
    public XmlStringBuilder toXML(String enclosingNamespace) {
        XmlStringBuilder builder = new XmlStringBuilder(this);
        builder.attribute("jid", this.jid);
        builder.optAttribute("node", this.getNode());
        builder.optAttribute("subid", this.id);
        builder.optAttribute("subscription", this.state.toString());
        builder.closeEmptyElement();
        return builder;
    }

    private static void appendAttribute(StringBuilder builder, String att, String value) {
        builder.append(' ');
        builder.append(att);
        builder.append("='");
        builder.append(value);
        builder.append('\'');
    }

    public static enum State {
        subscribed,
        unconfigured,
        pending,
        none;

    }
}

