/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.search;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.SimpleIQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.search.ReportedData;
import org.jivesoftware.smackx.search.SimpleUserSearch;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.DomainBareJid;
import org.xmlpull.v1.XmlPullParser;

public class UserSearch
extends SimpleIQ {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "jabber:iq:search";

    public UserSearch() {
        super(ELEMENT, NAMESPACE);
    }

    public Form getSearchForm(XMPPConnection con, DomainBareJid searchService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        UserSearch search = new UserSearch();
        search.setType(IQ.Type.get);
        search.setTo(searchService);
        IQ response = (IQ)con.createStanzaCollectorAndSend(search).nextResultOrThrow();
        return Form.getFormFrom(response);
    }

    public ReportedData sendSearchForm(XMPPConnection con, Form searchForm, DomainBareJid searchService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        UserSearch search = new UserSearch();
        search.setType(IQ.Type.set);
        search.setTo(searchService);
        search.addExtension(searchForm.getDataFormToSend());
        IQ response = (IQ)con.createStanzaCollectorAndSend(search).nextResultOrThrow();
        return ReportedData.getReportedDataFrom(response);
    }

    public ReportedData sendSimpleSearchForm(XMPPConnection con, Form searchForm, DomainBareJid searchService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        SimpleUserSearch search = new SimpleUserSearch();
        search.setForm(searchForm);
        search.setType(IQ.Type.set);
        search.setTo(searchService);
        SimpleUserSearch response = (SimpleUserSearch)con.createStanzaCollectorAndSend(search).nextResultOrThrow();
        return response.getReportedData();
    }

    private static void buildDataForm(SimpleUserSearch search, String instructions, XmlPullParser parser) throws Exception {
        DataForm dataForm = new DataForm(DataForm.Type.form);
        boolean done = false;
        dataForm.setTitle("User Search");
        dataForm.addInstruction(instructions);
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2 && !parser.getNamespace().equals("jabber:x:data")) {
                String name = parser.getName();
                FormField field = new FormField(name);
                if (name.equals("first")) {
                    field.setLabel("First Name");
                } else if (name.equals("last")) {
                    field.setLabel("Last Name");
                } else if (name.equals("email")) {
                    field.setLabel("Email Address");
                } else if (name.equals("nick")) {
                    field.setLabel("Nickname");
                }
                field.setType(FormField.Type.text_single);
                dataForm.addField(field);
                continue;
            }
            if (eventType == 3) {
                if (!parser.getName().equals(ELEMENT)) continue;
                done = true;
                continue;
            }
            if (eventType != 2 || !parser.getNamespace().equals("jabber:x:data")) continue;
            PacketParserUtils.addExtensionElement(search, parser);
            done = true;
        }
        if (search.getExtension("x", "jabber:x:data") == null) {
            search.addExtension(dataForm);
        }
    }

    public static class Provider
    extends IQProvider<IQ> {
        @Override
        public IQ parse(XmlPullParser parser, int initialDepth) throws Exception {
            UserSearch search = null;
            SimpleUserSearch simpleUserSearch = new SimpleUserSearch();
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2 && parser.getName().equals("instructions")) {
                    UserSearch.buildDataForm(simpleUserSearch, parser.nextText(), parser);
                    return simpleUserSearch;
                }
                if (eventType == 2 && parser.getName().equals("item")) {
                    simpleUserSearch.parseItems(parser);
                    return simpleUserSearch;
                }
                if (eventType == 2 && parser.getNamespace().equals("jabber:x:data")) {
                    search = new UserSearch();
                    PacketParserUtils.addExtensionElement(search, parser);
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals(UserSearch.ELEMENT)) continue;
                done = true;
            }
            if (search != null) {
                return search;
            }
            return simpleUserSearch;
        }
    }
}

