/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.TimeUtils;

@Metadata(label="eip,routing")
@XmlRootElement(name="sample")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SamplingDefinition
extends NoOutputDefinition<SamplingDefinition> {
    @XmlAttribute
    @Metadata(defaultValue="1000", javaType="java.time.Duration")
    private String samplePeriod;
    @XmlAttribute
    @Metadata(javaType="java.lang.Long")
    private String messageFrequency;

    public SamplingDefinition() {
    }

    protected SamplingDefinition(SamplingDefinition source) {
        super(source);
        this.samplePeriod = source.samplePeriod;
        this.messageFrequency = source.messageFrequency;
    }

    public SamplingDefinition(String samplePeriod) {
        this.samplePeriod = samplePeriod;
    }

    public SamplingDefinition(Duration period) {
        this.samplePeriod = TimeUtils.printDuration(period);
    }

    public SamplingDefinition(long samplePeriod, TimeUnit units) {
        this(Duration.ofMillis(units.toMillis(samplePeriod)));
    }

    public SamplingDefinition(long messageFrequency) {
        this.messageFrequency = Long.toString(messageFrequency);
    }

    @Override
    public SamplingDefinition copyDefinition() {
        return new SamplingDefinition(this);
    }

    @Override
    public String getShortName() {
        return "sample";
    }

    public String toString() {
        return "Sample[" + this.description() + " -> " + String.valueOf(this.getOutputs()) + "]";
    }

    protected String description() {
        if (this.messageFrequency != null) {
            return "1 Exchange per " + this.getMessageFrequency() + " messages received";
        }
        return "1 Exchange per " + TimeUtils.printDuration(TimeUtils.toDuration(this.samplePeriod));
    }

    @Override
    public String getLabel() {
        return "sample[" + this.description() + "]";
    }

    public SamplingDefinition sampleMessageFrequency(long messageFrequency) {
        this.setMessageFrequency(messageFrequency);
        return this;
    }

    public SamplingDefinition samplePeriod(Duration samplePeriod) {
        this.setSamplePeriod(samplePeriod);
        return this;
    }

    public SamplingDefinition samplePeriod(String samplePeriod) {
        this.setSamplePeriod(samplePeriod);
        return this;
    }

    public SamplingDefinition samplePeriod(long samplePeriod) {
        this.setSamplePeriod(samplePeriod);
        return this;
    }

    public String getSamplePeriod() {
        return this.samplePeriod;
    }

    public void setSamplePeriod(String samplePeriod) {
        this.samplePeriod = samplePeriod;
    }

    public void setSamplePeriod(long samplePeriod) {
        this.setSamplePeriod(Duration.ofMillis(samplePeriod));
    }

    public void setSamplePeriod(Duration samplePeriod) {
        this.samplePeriod = TimeUtils.printDuration(samplePeriod);
    }

    public String getMessageFrequency() {
        return this.messageFrequency;
    }

    public void setMessageFrequency(String messageFrequency) {
        this.messageFrequency = messageFrequency;
    }

    public void setMessageFrequency(long messageFrequency) {
        this.messageFrequency = Long.toString(messageFrequency);
    }
}

