/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.loadbalancer.LoadBalancerSupport;

public class TopicLoadBalancer
extends LoadBalancerSupport {
    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        AsyncProcessor[] processors = this.doGetProcessors();
        exchange.getContext().getCamelContextExtension().getReactiveExecutor().schedule(new State(exchange, callback, processors)::run);
        return false;
    }

    protected Exchange copyExchangeStrategy(Processor processor, Exchange exchange) {
        return exchange.copy();
    }

    protected class State {
        final Exchange exchange;
        final AsyncCallback callback;
        final AsyncProcessor[] processors;
        int index;

        public State(Exchange exchange, AsyncCallback callback, AsyncProcessor[] processors) {
            this.exchange = exchange;
            this.callback = callback;
            this.processors = processors;
        }

        public void run() {
            if (this.index < this.processors.length) {
                AsyncProcessor processor = this.processors[this.index++];
                Exchange copy = TopicLoadBalancer.this.copyExchangeStrategy(processor, this.exchange);
                processor.process(copy, doneSync -> this.done(copy));
            } else {
                this.callback.done(false);
            }
        }

        public void done(Exchange current) {
            if (current.getException() != null) {
                this.exchange.setException(current.getException());
                this.callback.done(false);
            } else {
                this.exchange.getContext().getCamelContextExtension().getReactiveExecutor().schedule(this::run);
            }
        }
    }
}

