/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.xpath;

import java.lang.annotation.Annotation;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.language.xpath.XPathBuilder;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.language.DefaultAnnotationExpressionFactory;
import org.apache.camel.support.language.LanguageAnnotation;
import org.apache.camel.support.language.NamespacePrefix;

public class XPathAnnotationExpressionFactory
extends DefaultAnnotationExpressionFactory {
    @Override
    public Expression createExpression(CamelContext camelContext, Annotation annotation, LanguageAnnotation languageAnnotation, Class<?> expressionReturnType) {
        String source;
        String xpath = this.getExpressionFromAnnotation(annotation);
        Class<?> resultType = this.getResultType(annotation);
        if (resultType.equals(Object.class)) {
            resultType = expressionReturnType;
        }
        XPathBuilder builder = XPathBuilder.xpath(xpath, resultType);
        builder.preCompile(this.isPreCompile(annotation));
        builder.setLogNamespaces(this.isLogNamespaces(annotation));
        NamespacePrefix[] namespaces = this.getExpressionNameSpacePrefix(annotation);
        if (namespaces != null) {
            for (NamespacePrefix namespacePrefix : namespaces) {
                builder = builder.namespace(namespacePrefix.prefix(), namespacePrefix.uri());
            }
        }
        if ((source = this.getSource(annotation)) != null) {
            builder.setSource(ExpressionBuilder.singleInputExpression(source));
        }
        return builder;
    }

    protected Class<?> getResultType(Annotation annotation) {
        return (Class)this.getAnnotationObjectValue(annotation, "resultType");
    }

    protected NamespacePrefix[] getExpressionNameSpacePrefix(Annotation annotation) {
        return (NamespacePrefix[])this.getAnnotationObjectValue(annotation, "namespaces");
    }

    protected String getSource(Annotation annotation) {
        String answer = null;
        try {
            answer = (String)this.getAnnotationObjectValue(annotation, "source");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (answer != null && answer.isBlank()) {
            return null;
        }
        return answer;
    }

    protected boolean isLogNamespaces(Annotation annotation) {
        try {
            return (Boolean)this.getAnnotationObjectValue(annotation, "logNamespaces");
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isPreCompile(Annotation annotation) {
        try {
            return (Boolean)this.getAnnotationObjectValue(annotation, "preCompile");
        }
        catch (Exception exception) {
            return false;
        }
    }
}

