/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.UpdateUserTaskCommandStep1;
import io.camunda.zeebe.client.api.response.UpdateUserTaskResponse;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.protocol.rest.UserTaskUpdateRequest;
import io.camunda.zeebe.client.protocol.rest.UserTaskUpdateRequestChangeset;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class UpdateUserTaskCommandImpl
implements UpdateUserTaskCommandStep1 {
    private final long userTaskKey;
    private final UserTaskUpdateRequest request;
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public UpdateUserTaskCommandImpl(HttpClient httpClient, JsonMapper jsonMapper, long userTaskKey) {
        this.jsonMapper = jsonMapper;
        this.userTaskKey = userTaskKey;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new UserTaskUpdateRequest();
    }

    @Override
    public FinalCommandStep<UpdateUserTaskResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<UpdateUserTaskResponse> send() {
        HttpZeebeFuture<UpdateUserTaskResponse> result = new HttpZeebeFuture<UpdateUserTaskResponse>();
        this.httpClient.patch("/user-tasks/" + this.userTaskKey, this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), result);
        return result;
    }

    @Override
    public UpdateUserTaskCommandStep1 action(String action) {
        this.request.setAction(action);
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 dueDate(String dueDate) {
        ArgumentUtil.ensureNotNull("dueDate", dueDate);
        this.getChangesetEnsureInitialized().dueDate(dueDate);
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 clearDueDate() {
        this.getChangesetEnsureInitialized().setDueDate("");
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 followUpDate(String followUpDate) {
        ArgumentUtil.ensureNotNull("followUpDate", followUpDate);
        this.getChangesetEnsureInitialized().followUpDate(followUpDate);
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 clearFollowUpDate() {
        this.getChangesetEnsureInitialized().followUpDate("");
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 candidateGroups(List<String> candidateGroups) {
        ArgumentUtil.ensureNotNull("candidateGroups", candidateGroups);
        this.getChangesetEnsureInitialized().candidateGroups(candidateGroups);
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 candidateGroups(String ... candidateGroups) {
        ArgumentUtil.ensureNotNull("candidateGroups", candidateGroups);
        this.getChangesetEnsureInitialized().candidateGroups(Arrays.asList(candidateGroups));
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 clearCandidateGroups() {
        this.getChangesetEnsureInitialized().setCandidateGroups(Collections.emptyList());
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 candidateUsers(List<String> candidateUsers) {
        ArgumentUtil.ensureNotNull("candidateUsers", candidateUsers);
        this.getChangesetEnsureInitialized().candidateUsers(candidateUsers);
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 candidateUsers(String ... candidateUsers) {
        ArgumentUtil.ensureNotNull("candidateUsers", candidateUsers);
        this.getChangesetEnsureInitialized().candidateUsers(Arrays.asList(candidateUsers));
        return this;
    }

    @Override
    public UpdateUserTaskCommandStep1 clearCandidateUsers() {
        this.getChangesetEnsureInitialized().candidateUsers(Collections.emptyList());
        return this;
    }

    private UserTaskUpdateRequestChangeset getChangesetEnsureInitialized() {
        UserTaskUpdateRequestChangeset changeset = this.request.getChangeset();
        if (changeset == null) {
            changeset = new UserTaskUpdateRequestChangeset();
            this.request.setChangeset(changeset);
        }
        return changeset;
    }
}

