/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.response.EvaluateDecisionResponse;
import io.camunda.zeebe.client.api.response.EvaluatedDecision;
import io.camunda.zeebe.client.impl.response.EvaluatedDecisionImpl;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.ArrayList;
import java.util.List;

public class EvaluateDecisionResponseImpl
implements EvaluateDecisionResponse {
    @JsonIgnore
    private final JsonMapper jsonMapper;
    private final String decisionId;
    private final long decisionKey;
    private final int decisionVersion;
    private final String decisionName;
    private final String decisionRequirementsId;
    private final long decisionRequirementsKey;
    private final String decisionOutput;
    private final List<EvaluatedDecision> evaluatedDecisions = new ArrayList<EvaluatedDecision>();
    private final String failedDecisionId;
    private final String failureMessage;
    private final String tenantId;
    private final long decisionInstanceKey;

    public EvaluateDecisionResponseImpl(JsonMapper jsonMapper, GatewayOuterClass.EvaluateDecisionResponse response) {
        this.jsonMapper = jsonMapper;
        this.decisionId = response.getDecisionId();
        this.decisionKey = response.getDecisionKey();
        this.decisionVersion = response.getDecisionVersion();
        this.decisionName = response.getDecisionName();
        this.decisionRequirementsId = response.getDecisionRequirementsId();
        this.decisionRequirementsKey = response.getDecisionRequirementsKey();
        this.decisionOutput = response.getDecisionOutput();
        this.failedDecisionId = response.getFailedDecisionId();
        this.failureMessage = response.getFailureMessage();
        this.tenantId = response.getTenantId();
        this.decisionInstanceKey = response.getDecisionInstanceKey();
        response.getEvaluatedDecisionsList().stream().map(evaluatedDecision -> new EvaluatedDecisionImpl(jsonMapper, (GatewayOuterClass.EvaluatedDecision)evaluatedDecision)).forEach(this.evaluatedDecisions::add);
    }

    @Override
    public String getDecisionId() {
        return this.decisionId;
    }

    @Override
    public int getDecisionVersion() {
        return this.decisionVersion;
    }

    @Override
    public long getDecisionKey() {
        return this.decisionKey;
    }

    @Override
    public String getDecisionName() {
        return this.decisionName;
    }

    @Override
    public String getDecisionRequirementsId() {
        return this.decisionRequirementsId;
    }

    @Override
    public long getDecisionRequirementsKey() {
        return this.decisionRequirementsKey;
    }

    @Override
    public String getDecisionOutput() {
        return this.decisionOutput;
    }

    @Override
    public List<EvaluatedDecision> getEvaluatedDecisions() {
        return this.evaluatedDecisions;
    }

    @Override
    public String getFailedDecisionId() {
        return this.failedDecisionId;
    }

    @Override
    public String getFailureMessage() {
        return this.failureMessage;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public long getDecisionInstanceKey() {
        return this.decisionInstanceKey;
    }
}

