/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Ordered;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConverter;
import org.apache.camel.WrappedFile;
import org.apache.camel.util.ReflectionHelper;
import org.apache.camel.util.Scanner;
import org.apache.camel.util.StringHelper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ObjectHelper {
    private static final Pattern PARENTHESIS_PATTERN = Pattern.compile(",(?!(?:[^\\(,]|[^\\)],[^\\)])+\\))");
    private static final String DEFAULT_DELIMITER = ",";
    private static final char DEFAULT_DELIMITER_CHAR = ',';

    private ObjectHelper() {
    }

    public static boolean typeCoerceEquals(TypeConverter converter, Object leftValue, Object rightValue) {
        return ObjectHelper.typeCoerceEquals(converter, leftValue, rightValue, false);
    }

    public static boolean typeCoerceEquals(TypeConverter converter, Object leftValue, Object rightValue, boolean ignoreCase) {
        if (leftValue == null || rightValue == null) {
            return ObjectHelper.evalNulls(leftValue, rightValue);
        }
        if (leftValue instanceof String) {
            return ObjectHelper.typeCoerceString(converter, leftValue, rightValue, ignoreCase);
        }
        if (rightValue instanceof String) {
            String str = (String)rightValue;
            if ((leftValue instanceof Integer || leftValue instanceof Long) && ObjectHelper.isNumber(str)) {
                return ObjectHelper.typeCoerceIntLong(leftValue, str);
            }
        }
        if (leftValue instanceof Integer && rightValue instanceof Integer) {
            return ObjectHelper.integerPairComparison(leftValue, rightValue);
        }
        if (leftValue instanceof Long && rightValue instanceof Long) {
            return ObjectHelper.longPairComparison(leftValue, rightValue);
        }
        if (leftValue instanceof Double && rightValue instanceof Double) {
            return ObjectHelper.doublePairComparison(leftValue, rightValue);
        }
        if (rightValue instanceof String) {
            String string = (String)rightValue;
            if (leftValue instanceof Boolean) {
                Boolean booleanValue = (Boolean)leftValue;
                return ObjectHelper.booleanStringComparison(booleanValue, string);
            }
        }
        return ObjectHelper.tryConverters(converter, leftValue, rightValue, ignoreCase);
    }

    private static boolean typeCoerceString(TypeConverter converter, Object leftValue, Object rightValue, boolean ignoreCase) {
        if (rightValue instanceof String) {
            String string = (String)rightValue;
            return ObjectHelper.typeCoerceStringPair((String)leftValue, string, ignoreCase);
        }
        if ((rightValue instanceof Integer || rightValue instanceof Long) && ObjectHelper.isNumber((String)leftValue)) {
            return ObjectHelper.typeCoerceILString((String)leftValue, rightValue);
        }
        if (rightValue instanceof Double) {
            Double doubleValue = (Double)rightValue;
            if (ObjectHelper.isFloatingNumber((String)leftValue)) {
                return ObjectHelper.stringDoubleComparison((String)leftValue, doubleValue);
            }
        }
        if (rightValue instanceof Boolean) {
            return ObjectHelper.stringBooleanComparison(leftValue, rightValue);
        }
        return ObjectHelper.tryConverters(converter, leftValue, rightValue, ignoreCase);
    }

    private static boolean evalNulls(Object leftValue, Object rightValue) {
        return leftValue == rightValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tryConverters(TypeConverter converter, Object leftValue, Object rightValue, boolean ignoreCase) {
        boolean isEqual = org.apache.camel.util.ObjectHelper.equal(leftValue, rightValue, ignoreCase);
        if (isEqual) {
            return true;
        }
        if (leftValue.getClass().isInstance(rightValue)) {
            return false;
        }
        StreamCache sc = null;
        try {
            Object value;
            boolean isEqualLeftToRight;
            if (leftValue instanceof StreamCache) {
                StreamCache streamCache;
                sc = streamCache = (StreamCache)leftValue;
            }
            if (isEqualLeftToRight = org.apache.camel.util.ObjectHelper.equal(value = converter.tryConvertTo(rightValue.getClass(), leftValue), rightValue, ignoreCase)) {
                boolean bl = true;
                return bl;
            }
            if (rightValue instanceof StreamCache) {
                StreamCache streamCache;
                sc = streamCache = (StreamCache)rightValue;
            }
            value = converter.tryConvertTo(leftValue.getClass(), rightValue);
            boolean bl = org.apache.camel.util.ObjectHelper.equal(leftValue, value, ignoreCase);
            return bl;
        }
        finally {
            if (sc != null) {
                sc.reset();
            }
        }
    }

    private static boolean booleanStringComparison(Boolean leftBool, String rightValue) {
        Boolean rightBool = Boolean.valueOf(rightValue);
        return leftBool.compareTo(rightBool) == 0;
    }

    private static boolean doublePairComparison(Object leftValue, Object rightValue) {
        return ObjectHelper.doublePairComparison((Double)leftValue, (Double)rightValue);
    }

    private static boolean doublePairComparison(Double leftValue, Double rightValue) {
        return leftValue.compareTo(rightValue) == 0;
    }

    private static boolean longPairComparison(Object leftValue, Object rightValue) {
        return ObjectHelper.longPairComparison((Long)leftValue, (Long)rightValue);
    }

    private static boolean longPairComparison(Long leftValue, Long rightValue) {
        return leftValue.compareTo(rightValue) == 0;
    }

    private static boolean integerPairComparison(Object leftValue, Object rightValue) {
        return ObjectHelper.integerPairComparison((Integer)leftValue, (Integer)rightValue);
    }

    private static boolean integerPairComparison(Integer leftValue, Integer rightValue) {
        return leftValue.compareTo(rightValue) == 0;
    }

    private static boolean stringBooleanComparison(Object leftValue, Object rightValue) {
        return ObjectHelper.stringBooleanComparison((String)leftValue, (Boolean)rightValue);
    }

    private static boolean stringBooleanComparison(String leftValue, Boolean rightValue) {
        Boolean leftBool = Boolean.valueOf(leftValue);
        return leftBool.compareTo(rightValue) == 0;
    }

    private static boolean stringDoubleComparison(String leftValue, Double rightValue) {
        return ObjectHelper.doublePairComparison(Double.valueOf(leftValue), rightValue);
    }

    private static boolean typeCoerceIntLong(Object leftValue, String rightValue) {
        if (leftValue instanceof Integer) {
            return ObjectHelper.integerPairComparison((Integer)leftValue, Integer.valueOf(rightValue));
        }
        return ObjectHelper.longPairComparison((Long)leftValue, Long.valueOf(rightValue));
    }

    private static boolean typeCoerceILString(String leftValue, Object rightValue) {
        if (rightValue instanceof Integer) {
            return ObjectHelper.integerPairComparison(Integer.valueOf(leftValue), (Integer)rightValue);
        }
        return ObjectHelper.longPairComparison(Long.valueOf(leftValue), (Long)rightValue);
    }

    private static boolean typeCoerceStringPair(String leftNum, String rightNum, boolean ignoreCase) {
        if (ObjectHelper.isNumber(leftNum) && ObjectHelper.isNumber(rightNum)) {
            return ObjectHelper.longPairComparison(Long.parseLong(leftNum), Long.parseLong(rightNum));
        }
        if (ignoreCase) {
            return leftNum.compareToIgnoreCase(rightNum) == 0;
        }
        return leftNum.compareTo(rightNum) == 0;
    }

    public static boolean typeCoerceNotEquals(TypeConverter converter, Object leftValue, Object rightValue) {
        return !ObjectHelper.typeCoerceEquals(converter, leftValue, rightValue);
    }

    public static int typeCoerceCompare(TypeConverter converter, Object leftValue, Object rightValue) {
        Object value;
        String leftStr;
        Object leftNum;
        if (leftValue instanceof String) {
            leftNum = (String)leftValue;
            if (rightValue instanceof String) {
                String rightNum = (String)rightValue;
                return ObjectHelper.typeCoerceCompareStringString((String)leftNum, rightNum);
            }
        }
        if (leftValue instanceof Integer) {
            Integer leftNum2 = (Integer)leftValue;
            if (rightValue instanceof Integer) {
                Integer rightNum = (Integer)rightValue;
                return leftNum2.compareTo(rightNum);
            }
        }
        if (leftValue instanceof Long) {
            Long leftNum3 = (Long)leftValue;
            if (rightValue instanceof Long) {
                Long rightNum = (Long)rightValue;
                return leftNum3.compareTo(rightNum);
            }
        }
        if (leftValue instanceof Double) {
            Double leftNum4 = (Double)leftValue;
            if (rightValue instanceof Double) {
                Double rightNum = (Double)rightValue;
                return leftNum4.compareTo(rightNum);
            }
        }
        if (leftValue instanceof Float) {
            Float leftNum5 = (Float)leftValue;
            if (rightValue instanceof Float) {
                Float rightNum = (Float)rightValue;
                return leftNum5.compareTo(rightNum);
            }
        }
        if ((rightValue instanceof Integer || rightValue instanceof Long) && leftValue instanceof String && ObjectHelper.isNumber(leftStr = (String)leftValue)) {
            if (rightValue instanceof Integer) {
                Integer rightNum = (Integer)rightValue;
                Integer leftNum6 = Integer.valueOf(leftStr);
                return leftNum6.compareTo(rightNum);
            }
            Long leftNum7 = Long.valueOf(leftStr);
            Long rightNum = (Long)rightValue;
            return leftNum7.compareTo(rightNum);
        }
        if (rightValue instanceof String && (leftValue instanceof Integer || leftValue instanceof Long) && ObjectHelper.isNumber((String)rightValue)) {
            if (leftValue instanceof Integer) {
                Integer leftNum8 = (Integer)leftValue;
                Integer rightNum = Integer.valueOf((String)rightValue);
                return leftNum8.compareTo(rightNum);
            }
            Long leftNum9 = (Long)leftValue;
            Long rightNum = Long.valueOf((String)rightValue);
            return leftNum9.compareTo(rightNum);
        }
        if (rightValue instanceof Double) {
            Double rightNum = (Double)rightValue;
            if (leftValue instanceof String && ObjectHelper.isFloatingNumber((String)leftValue)) {
                Double leftNum10 = Double.valueOf((String)leftValue);
                return leftNum10.compareTo(rightNum);
            }
        }
        if (rightValue instanceof Float) {
            Float rightNum = (Float)rightValue;
            if (leftValue instanceof String && ObjectHelper.isFloatingNumber((String)leftValue)) {
                Float leftNum11 = Float.valueOf((String)leftValue);
                return leftNum11.compareTo(rightNum);
            }
        }
        if (rightValue instanceof Boolean) {
            Boolean rightBool = (Boolean)rightValue;
            if (leftValue instanceof String) {
                Boolean leftBool = Boolean.valueOf((String)leftValue);
                return leftBool.compareTo(rightBool);
            }
        }
        if (rightValue instanceof String && leftValue instanceof Boolean) {
            Boolean leftBool = (Boolean)leftValue;
            Boolean rightBool = Boolean.valueOf((String)rightValue);
            return leftBool.compareTo(rightBool);
        }
        leftNum = converter.tryConvertTo(Long.class, leftValue);
        Long rightNum = converter.tryConvertTo(Long.class, rightValue);
        if (leftNum != null && rightNum != null) {
            return ((Long)leftNum).compareTo(rightNum);
        }
        Double leftDouble = converter.tryConvertTo(Double.class, leftValue);
        Double rightDouble = converter.tryConvertTo(Double.class, rightValue);
        if (leftDouble != null && rightDouble != null) {
            return leftDouble.compareTo(rightDouble);
        }
        if (rightValue instanceof String) {
            return ObjectHelper.typeCoerceCompare(converter, rightValue, leftValue) * -1;
        }
        if (rightValue instanceof Comparable) {
            Comparable rightComparable = (Comparable)rightValue;
            value = converter.tryConvertTo(rightValue.getClass(), leftValue);
            if (value != null) {
                return rightComparable.compareTo(value) * -1;
            }
        }
        if (leftValue instanceof Comparable) {
            Comparable leftComparable = (Comparable)leftValue;
            value = converter.tryConvertTo(leftValue.getClass(), rightValue);
            if (value != null) {
                return leftComparable.compareTo(value);
            }
        }
        return ObjectHelper.compare(leftValue, rightValue);
    }

    private static int typeCoerceCompareStringString(String leftNum, String rightNum) {
        Double dec2;
        Long num1 = ObjectHelper.isNumber(leftNum) ? Long.valueOf(Long.parseLong(leftNum)) : null;
        Long num2 = ObjectHelper.isNumber(rightNum) ? Long.valueOf(Long.parseLong(rightNum)) : null;
        Double dec1 = num1 == null && ObjectHelper.isFloatingNumber(leftNum) ? Double.valueOf(Double.parseDouble(leftNum)) : null;
        Double d = dec2 = num2 == null && ObjectHelper.isFloatingNumber(rightNum) ? Double.valueOf(Double.parseDouble(rightNum)) : null;
        if (num1 != null && num2 != null) {
            return num1.compareTo(num2);
        }
        if (dec1 != null && dec2 != null) {
            return dec1.compareTo(dec2);
        }
        if (num1 != null && dec2 != null) {
            dec1 = Double.parseDouble(leftNum);
            return dec1.compareTo(dec2);
        }
        if (num2 != null && dec1 != null) {
            dec2 = Double.parseDouble(rightNum);
            return dec1.compareTo(dec2);
        }
        return leftNum.compareTo(rightNum);
    }

    public static boolean isNumber(String text) {
        int startPos = ObjectHelper.findStartPosition(text);
        if (startPos < 0) {
            return false;
        }
        for (int i = startPos; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (Character.isDigit(ch)) continue;
            return false;
        }
        return true;
    }

    private static int findStartPosition(String text) {
        if (text == null || text.isEmpty()) {
            return -1;
        }
        int startPos = 0;
        if (text.charAt(0) == '-') {
            if (text.length() == 1) {
                return -1;
            }
            startPos = 1;
        }
        return startPos;
    }

    public static boolean isFloatingNumber(String text) {
        int startPos = ObjectHelper.findStartPosition(text);
        if (startPos < 0) {
            return false;
        }
        boolean dots = false;
        boolean digits = false;
        char ch = '\u0000';
        for (int i = startPos; i < text.length(); ++i) {
            ch = text.charAt(i);
            if (!Character.isDigit(ch)) {
                if (ch == '.') {
                    if (dots) {
                        return false;
                    }
                    dots = true;
                    continue;
                }
                return false;
            }
            digits = true;
        }
        return digits && text.charAt(startPos) != '.' && ch != '.';
    }

    public static Object invokeMethod(Method method, Object instance, Object ... parameters) {
        try {
            if (parameters != null) {
                return method.invoke(instance, parameters);
            }
            return method.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeCamelException(e);
        }
        catch (InvocationTargetException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e.getCause());
        }
    }

    public static Object invokeMethodSafe(Method method, Object instance, Object ... parameters) throws InvocationTargetException, IllegalAccessException {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        Object answer = parameters != null ? method.invoke(instance, parameters) : method.invoke(instance, new Object[0]);
        return answer;
    }

    public static Object invokeMethodSafe(String name, Object instance, Object ... parameters) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Method m4;
        Class[] arr = null;
        if (parameters != null) {
            arr = new Class[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                Object p = parameters[i];
                if (p == null) continue;
                arr[i] = p.getClass();
            }
        }
        if ((m4 = ReflectionHelper.findMethod(instance.getClass(), name, arr)) != null) {
            return ObjectHelper.invokeMethodSafe(m4, instance, parameters);
        }
        throw new NoSuchMethodException(name);
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    public static <T> T newInstance(Class<?> actualType, Class<T> expectedType) {
        try {
            Object value = actualType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return org.apache.camel.util.ObjectHelper.cast(expectedType, value);
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    public static int compare(Object a, Object b) {
        return ObjectHelper.compare(a, b, false);
    }

    public static int compare(Object a, Object b, boolean ignoreCase) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Ordered) {
            Ordered orderedA = (Ordered)a;
            if (b instanceof Ordered) {
                Ordered orderedB = (Ordered)b;
                return orderedA.getOrder() - orderedB.getOrder();
            }
        }
        if (ignoreCase && a instanceof String) {
            String strA = (String)a;
            if (b instanceof String) {
                String strB = (String)b;
                return strA.compareToIgnoreCase(strB);
            }
        }
        if (a instanceof Comparable) {
            Comparable comparable = (Comparable)a;
            return comparable.compareTo(b);
        }
        int answer = a.getClass().getName().compareTo(b.getClass().getName());
        if (answer == 0) {
            answer = a.hashCode() - b.hashCode();
        }
        return answer;
    }

    public static Object callWithTCCL(Callable<?> call, Exchange exchange) throws Exception {
        ClassLoader apcl = null;
        if (exchange != null && exchange.getContext() != null) {
            apcl = exchange.getContext().getApplicationContextClassLoader();
        }
        return ObjectHelper.callWithTCCL(call, apcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callWithTCCL(Callable<?> call, ClassLoader classloader) throws Exception {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            if (classloader != null) {
                Thread.currentThread().setContextClassLoader(classloader);
            }
            Object obj = call.call();
            return obj;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public static Iterable<?> createIterable(Object value) {
        return ObjectHelper.createIterable(value, DEFAULT_DELIMITER);
    }

    public static Iterable<?> createIterable(Object value, String delimiter) {
        return ObjectHelper.createIterable(value, delimiter, false);
    }

    public static Iterable<String> createIterable(String value) {
        return ObjectHelper.createIterable(value, DEFAULT_DELIMITER);
    }

    public static Iterable<String> createIterable(String value, String delimiter) {
        return ObjectHelper.createIterable(value, delimiter, false);
    }

    public static Iterable<String> createIterable(String value, String delimiter, boolean allowEmptyValues) {
        return ObjectHelper.createIterable(value, delimiter, allowEmptyValues, false);
    }

    public static Iterable<String> createIterable(String value, String delimiter, boolean allowEmptyValues, boolean pattern) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (delimiter != null && (pattern || value.contains(delimiter))) {
            if (DEFAULT_DELIMITER.equals(delimiter)) {
                if (value.indexOf(40) != -1 && value.indexOf(41) != -1) {
                    return () -> new Scanner(value, PARENTHESIS_PATTERN);
                }
                int count = StringHelper.countChar(value, ',') + 1;
                return () -> StringHelper.splitOnCharacterAsIterator(value, ',', count);
            }
            if (pattern) {
                return () -> new StringIteratorForPattern(value, delimiter);
            }
            return () -> new StringIterator(value, delimiter);
        }
        if (allowEmptyValues || org.apache.camel.util.ObjectHelper.isNotEmpty(value)) {
            return Collections.singletonList(value);
        }
        return Collections.emptyList();
    }

    public static Iterator<?> createIterator(Object value) {
        return ObjectHelper.createIterator(value, DEFAULT_DELIMITER);
    }

    public static Iterator<?> createIterator(Object value, String delimiter) {
        return ObjectHelper.createIterator(value, delimiter, false);
    }

    public static Iterator<?> createIterator(Object value, String delimiter, boolean allowEmptyValues) {
        if (value instanceof Stream) {
            Stream stream = (Stream)value;
            return stream.iterator();
        }
        return ObjectHelper.createIterable(value, delimiter, allowEmptyValues, false).iterator();
    }

    public static Iterator<?> createIterator(Object value, String delimiter, boolean allowEmptyValues, boolean pattern) {
        if (value instanceof Stream) {
            Stream stream = (Stream)value;
            return stream.iterator();
        }
        return ObjectHelper.createIterable(value, delimiter, allowEmptyValues, pattern).iterator();
    }

    public static Iterable<?> createIterable(Object value, String delimiter, boolean allowEmptyValues) {
        return ObjectHelper.createIterable(value, delimiter, allowEmptyValues, false);
    }

    public static Iterable<?> createIterable(Object value, String delimiter, boolean allowEmptyValues, boolean pattern) {
        if (value instanceof Message) {
            Message message = (Message)value;
            value = message.getBody();
        }
        if (value == null) {
            return Collections.emptyList();
        }
        if (ObjectHelper.fastStringCheck(value)) {
            return ObjectHelper.createStringIterator((String)value, delimiter, allowEmptyValues, pattern);
        }
        if (ObjectHelper.fastIsMap(value)) {
            Map map = (Map)value;
            return map.entrySet();
        }
        if (value.getClass().isArray()) {
            return ObjectHelper.createArrayIterator(value);
        }
        return ObjectHelper.trySlowIterables(value);
    }

    private static Iterable<?> trySlowIterables(Object value) {
        if (value instanceof Iterator) {
            Iterator iterator = (Iterator)value;
            return () -> iterator;
        }
        if (value instanceof Iterable) {
            return (Iterable)value;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.entrySet();
        }
        if (value instanceof NodeList) {
            NodeList nodeList = (NodeList)value;
            return () -> ObjectHelper.createNodeListIterator(nodeList);
        }
        return Collections.singletonList(value);
    }

    private static boolean fastStringCheck(Object obj) {
        return obj.getClass() == String.class;
    }

    private static boolean fastIsMap(Object obj) {
        return obj.getClass() == HashMap.class || obj.getClass() == ConcurrentHashMap.class || obj.getClass() == ConcurrentSkipListMap.class || obj.getClass() == EnumMap.class || obj.getClass() == LinkedHashMap.class || obj.getClass() == TreeMap.class || obj.getClass() == WeakHashMap.class;
    }

    private static Iterable<Object> createArrayIterator(Object value) {
        if (org.apache.camel.util.ObjectHelper.isPrimitiveArrayType(value.getClass())) {
            Object array = value;
            return () -> ObjectHelper.createPrimitiveArrayIterator(array);
        }
        return Arrays.asList((Object[])value);
    }

    private static Iterable<?> createStringIterator(String value, String delimiter, boolean allowEmptyValues, boolean pattern) {
        String s2 = value;
        if (delimiter != null && (pattern || s2.contains(delimiter))) {
            if (DEFAULT_DELIMITER.equals(delimiter)) {
                return ObjectHelper.createDelimitedStringIterator(s2);
            }
            if (pattern) {
                return () -> new StringIteratorForPattern(s2, delimiter);
            }
            return () -> new StringIterator(s2, delimiter);
        }
        return () -> ObjectHelper.createPlainIterator(allowEmptyValues, s2);
    }

    private static Iterable<String> createDelimitedStringIterator(String s2) {
        if (s2.indexOf(40) != -1 && s2.indexOf(41) != -1) {
            return () -> new Scanner(s2, PARENTHESIS_PATTERN);
        }
        int count = StringHelper.countChar(s2, ',') + 1;
        return () -> StringHelper.splitOnCharacterAsIterator(s2, ',', count);
    }

    private static Iterator<Object> createPlainIterator(final boolean allowEmptyValues, final String s2) {
        return new Iterator<Object>(){
            private int idx;

            @Override
            public boolean hasNext() {
                return this.idx == 0 && (allowEmptyValues || org.apache.camel.util.ObjectHelper.isNotEmpty(s2));
            }

            @Override
            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("no more element available for '" + s2 + "' at the index " + this.idx);
                }
                ++this.idx;
                return s2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static Iterator<Node> createNodeListIterator(final NodeList nodeList) {
        return new Iterator<Node>(){
            private int idx;

            @Override
            public boolean hasNext() {
                return this.idx < nodeList.getLength();
            }

            @Override
            public Node next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("no more element available for '" + String.valueOf(nodeList) + "' at the index " + this.idx);
                }
                return nodeList.item(this.idx++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static Iterator<Object> createPrimitiveArrayIterator(final Object array) {
        return new Iterator<Object>(){
            private int idx;

            @Override
            public boolean hasNext() {
                return this.idx < Array.getLength(array);
            }

            @Override
            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("no more element available for '" + String.valueOf(array) + "' at the index " + this.idx);
                }
                return Array.get(array, this.idx++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean typeCoerceContains(TypeConverter typeConverter, Object collectionOrArray, Object value, boolean ignoreCase) {
        if (collectionOrArray instanceof WrappedFile) {
            WrappedFile wf = (WrappedFile)collectionOrArray;
            collectionOrArray = wf.getBody();
        }
        if (collectionOrArray instanceof StreamCache) {
            StreamCache sc = (StreamCache)collectionOrArray;
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                sc.writeTo(bos);
                collectionOrArray = bos.toByteArray();
            }
            catch (IOException bos) {
            }
            finally {
                sc.reset();
            }
        }
        if (value instanceof StringBuffer || value instanceof StringBuilder) {
            value = value.toString();
        }
        if (collectionOrArray instanceof StringBuffer || collectionOrArray instanceof StringBuilder) {
            collectionOrArray = collectionOrArray.toString();
        }
        if (collectionOrArray instanceof byte[]) {
            byte[] arr = (byte[])collectionOrArray;
            collectionOrArray = new String(arr);
        }
        if (collectionOrArray instanceof Collection) {
            Collection collection = (Collection)collectionOrArray;
            if (ignoreCase) {
                String lower = value.toString().toLowerCase(Locale.ENGLISH);
                return collection.stream().anyMatch(c -> c.toString().toLowerCase(Locale.ENGLISH).contains(lower));
            }
            return collection.contains(value);
        }
        if (collectionOrArray instanceof String) {
            String strValue;
            String str = (String)collectionOrArray;
            String subStr = value instanceof String ? (strValue = (String)value) : typeConverter.tryConvertTo(String.class, value);
            if (subStr != null) {
                if (ignoreCase) {
                    String lower = subStr.toLowerCase(Locale.ENGLISH);
                    return str.toLowerCase(Locale.ENGLISH).contains(lower);
                }
                return str.contains(subStr);
            }
        }
        Iterator<?> iter = ObjectHelper.createIterator(collectionOrArray);
        while (iter.hasNext()) {
            if (!ObjectHelper.typeCoerceEquals(typeConverter, value, iter.next(), ignoreCase)) continue;
            return true;
        }
        return false;
    }

    private static class StringIterator
    implements Iterator<String> {
        private boolean computed;
        private int from;
        private int to;
        private final String content;
        private final String separator;
        private final int separatorLength;
        private final int contentLength;

        StringIterator(String content, String separator) {
            this.content = content;
            this.separator = separator;
            this.separatorLength = separator.length();
            boolean skipStart = content.startsWith(separator);
            boolean skipEnd = content.endsWith(separator);
            if (skipStart && skipEnd) {
                this.from = this.separatorLength;
                this.contentLength = content.length() - this.separatorLength;
            } else if (skipStart) {
                this.from = this.separatorLength;
                this.contentLength = content.length();
            } else {
                this.contentLength = skipEnd ? content.length() - this.separatorLength : content.length();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.computed) {
                return this.to != -1;
            }
            if (this.to == -1) {
                return false;
            }
            int index = this.content.indexOf(this.separator, this.from);
            this.to = index == -1 || index == this.contentLength ? this.contentLength : index;
            this.computed = true;
            return true;
        }

        @Override
        public String next() {
            String answer;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.to == this.contentLength) {
                answer = this.content.substring(this.from, this.contentLength);
                this.to = -1;
            } else {
                answer = this.content.substring(this.from, this.to);
                this.from = this.to + this.separatorLength;
            }
            this.computed = false;
            return answer;
        }
    }

    private static class StringIteratorForPattern
    implements Iterator<String> {
        private boolean computed;
        private int from;
        private int to;
        private final String content;
        private final Matcher matcher;
        private int contentLength;

        StringIteratorForPattern(String content, String pattern) {
            this.content = content;
            this.matcher = Pattern.compile(pattern).matcher(content);
            this.matcher.useTransparentBounds(true);
            this.matcher.useAnchoringBounds(false);
            this.contentLength = content.length();
        }

        @Override
        public boolean hasNext() {
            block5: {
                block4: {
                    while (true) {
                        if (this.computed) {
                            return this.to != -1;
                        }
                        if (this.to == -1) {
                            return false;
                        }
                        if (!this.matcher.find(this.from)) break block4;
                        this.to = this.matcher.start();
                        if (this.from != this.to) break;
                        this.from = this.matcher.end();
                    }
                    if (this.matcher.end() == this.contentLength) {
                        this.contentLength = this.to;
                    }
                    break block5;
                }
                this.to = this.contentLength;
            }
            this.computed = true;
            return true;
        }

        @Override
        public String next() {
            String answer;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.to == this.contentLength) {
                answer = this.content.substring(this.from, this.contentLength);
                this.to = -1;
            } else {
                answer = this.content.substring(this.from, this.to);
                this.from = this.matcher.end();
            }
            this.computed = false;
            return answer;
        }
    }
}

