/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.xml.impl.validation;

import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.validation.ValidationResult;
import org.camunda.bpm.model.xml.validation.ValidationResultFormatter;
import org.camunda.bpm.model.xml.validation.ValidationResults;

public class ModelValidationResultsImpl
implements ValidationResults {
    protected Map<ModelElementInstance, List<ValidationResult>> collectedResults;
    protected int errorCount;
    protected int warningCount;

    public ModelValidationResultsImpl(Map<ModelElementInstance, List<ValidationResult>> collectedResults, int errorCount, int warningCount) {
        this.collectedResults = collectedResults;
        this.errorCount = errorCount;
        this.warningCount = warningCount;
    }

    @Override
    public boolean hasErrors() {
        return this.errorCount > 0;
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getWarinigCount() {
        return this.warningCount;
    }

    @Override
    public void write(StringWriter writer, ValidationResultFormatter formatter) {
        for (Map.Entry<ModelElementInstance, List<ValidationResult>> entry : this.collectedResults.entrySet()) {
            ModelElementInstance element = entry.getKey();
            List<ValidationResult> results = entry.getValue();
            formatter.formatElement(writer, element);
            for (ValidationResult result : results) {
                formatter.formatResult(writer, result);
            }
        }
    }

    @Override
    public Map<ModelElementInstance, List<ValidationResult>> getResults() {
        return this.collectedResults;
    }
}

