/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.ActivateJobsCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.ActivateJobsResponse;
import io.camunda.zeebe.client.impl.RetriableStreamingFutureImpl;
import io.camunda.zeebe.client.impl.response.ActivateJobsResponseImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class ActivateJobsCommandImpl
implements ActivateJobsCommandStep1,
ActivateJobsCommandStep1.ActivateJobsCommandStep2,
ActivateJobsCommandStep1.ActivateJobsCommandStep3 {
    private static final Duration DEADLINE_OFFSET = Duration.ofSeconds(10L);
    private final GatewayGrpc.GatewayStub asyncStub;
    private final JsonMapper jsonMapper;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private final GatewayOuterClass.ActivateJobsRequest.Builder builder;
    private Duration requestTimeout;
    private final Set<String> defaultTenantIds;
    private final Set<String> customTenantIds;

    public ActivateJobsCommandImpl(GatewayGrpc.GatewayStub asyncStub, ZeebeClientConfiguration config, JsonMapper jsonMapper, Predicate<CredentialsProvider.StatusCode> retryPredicate) {
        this.asyncStub = asyncStub;
        this.jsonMapper = jsonMapper;
        this.retryPredicate = retryPredicate;
        this.builder = GatewayOuterClass.ActivateJobsRequest.newBuilder();
        this.requestTimeout(config.getDefaultRequestTimeout());
        this.timeout(config.getDefaultJobTimeout());
        this.workerName(config.getDefaultJobWorkerName());
        this.defaultTenantIds = new HashSet<String>(config.getDefaultJobWorkerTenantIds());
        this.customTenantIds = new HashSet<String>();
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep2 jobType(String jobType) {
        this.builder.setType(jobType);
        return this;
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 maxJobsToActivate(int maxJobsToActivate) {
        this.builder.setMaxJobsToActivate(maxJobsToActivate);
        return this;
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 timeout(Duration timeout) {
        this.builder.setTimeout(timeout.toMillis());
        return this;
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 workerName(String workerName) {
        if (workerName != null) {
            this.builder.setWorker(workerName);
        }
        return this;
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 fetchVariables(List<String> fetchVariables) {
        this.builder.addAllFetchVariable(fetchVariables);
        return this;
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 fetchVariables(String ... fetchVariables) {
        return this.fetchVariables(Arrays.asList(fetchVariables));
    }

    @Override
    public FinalCommandStep<ActivateJobsResponse> requestTimeout(Duration requestTimeout) {
        this.builder.setRequestTimeout(requestTimeout.toMillis());
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<ActivateJobsResponse> send() {
        this.builder.clearTenantIds();
        if (this.customTenantIds.isEmpty()) {
            this.builder.addAllTenantIds(this.defaultTenantIds);
        } else {
            this.builder.addAllTenantIds(this.customTenantIds);
        }
        GatewayOuterClass.ActivateJobsRequest request = this.builder.build();
        ActivateJobsResponseImpl response = new ActivateJobsResponseImpl(this.jsonMapper);
        RetriableStreamingFutureImpl<ActivateJobsResponseImpl, GatewayOuterClass.ActivateJobsResponse> future = new RetriableStreamingFutureImpl<ActivateJobsResponseImpl, GatewayOuterClass.ActivateJobsResponse>(response, response::addResponse, this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.ActivateJobsResponse>)streamObserver));
        this.send(request, future);
        return future;
    }

    private void send(GatewayOuterClass.ActivateJobsRequest request, StreamObserver<GatewayOuterClass.ActivateJobsResponse> future) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.plus(DEADLINE_OFFSET).toMillis(), TimeUnit.MILLISECONDS)).activateJobs(request, future);
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 tenantId(String tenantId) {
        this.customTenantIds.add(tenantId);
        return this;
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 tenantIds(List<String> tenantIds) {
        this.customTenantIds.clear();
        this.customTenantIds.addAll(tenantIds);
        return this;
    }

    @Override
    public ActivateJobsCommandStep1.ActivateJobsCommandStep3 tenantIds(String ... tenantIds) {
        return this.tenantIds((List)Arrays.asList(tenantIds));
    }
}

