/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.UnassignUserTaskCommandStep1;
import io.camunda.zeebe.client.api.response.UnassignUserTaskResponse;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class UnassignUserTaskCommandImpl
implements UnassignUserTaskCommandStep1 {
    private final long userTaskKey;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public UnassignUserTaskCommandImpl(HttpClient httpClient, long userTaskKey) {
        this.userTaskKey = userTaskKey;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalCommandStep<UnassignUserTaskResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<UnassignUserTaskResponse> send() {
        HttpZeebeFuture<UnassignUserTaskResponse> result = new HttpZeebeFuture<UnassignUserTaskResponse>();
        this.httpClient.delete("/user-tasks/" + this.userTaskKey + "/assignee", this.httpRequestConfig.build(), result);
        return result;
    }
}

