/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.http;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.json.async.NonBlockingByteBufferJsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import io.camunda.zeebe.client.impl.http.ApiEntity;
import io.camunda.zeebe.client.protocol.rest.ProblemDetail;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.entity.AbstractBinAsyncEntityConsumer;

final class ApiEntityConsumer<T>
extends AbstractBinAsyncEntityConsumer<ApiEntity<T>> {
    private final ObjectMapper json;
    private final Class<T> type;
    private final int maxCapacity;
    private NonBlockingByteBufferJsonParser parser;
    private TokenBuffer buffer;
    private int bufferedBytes;
    private boolean isResponse;
    private boolean isUnknownContentType;
    private byte[] nonJsonBody;

    ApiEntityConsumer(ObjectMapper json, Class<T> type, int maxCapacity) {
        this.json = json;
        this.type = type;
        this.maxCapacity = maxCapacity;
    }

    @Override
    protected void streamStart(ContentType contentType) throws IOException {
        if (ContentType.APPLICATION_JSON.isSameMimeType(contentType)) {
            this.isResponse = true;
        } else if (ContentType.APPLICATION_PROBLEM_JSON.isSameMimeType(contentType)) {
            this.isResponse = false;
        } else {
            this.isUnknownContentType = true;
            this.nonJsonBody = new byte[1024];
            return;
        }
        this.parser = (NonBlockingByteBufferJsonParser)this.json.getFactory().createNonBlockingByteBufferParser();
        this.buffer = new TokenBuffer(this.parser, this.json.getDeserializationContext());
    }

    @Override
    protected ApiEntity<T> generateContent() throws IOException {
        if (this.parser == null || this.buffer == null) {
            if (this.nonJsonBody == null || this.bufferedBytes == 0) {
                return null;
            }
            return ApiEntity.of(ByteBuffer.wrap(this.nonJsonBody, 0, this.bufferedBytes));
        }
        this.buffer.asParserOnFirstToken();
        if (this.isResponse) {
            return ApiEntity.of(this.json.readValue(this.buffer.asParserOnFirstToken(), this.type));
        }
        return ApiEntity.of(this.json.readValue(this.buffer.asParserOnFirstToken(), ProblemDetail.class));
    }

    @Override
    protected int capacityIncrement() {
        return this.maxCapacity - this.bufferedBytes;
    }

    @Override
    protected void data(ByteBuffer src, boolean endOfStream) throws IOException {
        int offset = this.bufferedBytes;
        this.bufferedBytes += src.remaining();
        if (this.isUnknownContentType) {
            this.consumeNonJsonBody(src, offset);
        } else {
            this.consumeJsonBody(src, endOfStream);
        }
    }

    @Override
    public void releaseResources() {
        if (this.parser != null) {
            try {
                this.parser.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.buffer != null) {
            try {
                this.buffer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.bufferedBytes = 0;
    }

    private void consumeNonJsonBody(ByteBuffer src, int offset) {
        if (this.nonJsonBody.length < this.bufferedBytes) {
            this.nonJsonBody = Arrays.copyOf(this.nonJsonBody, this.nonJsonBody.length + 1024);
        }
        src.get(this.nonJsonBody, offset, src.remaining());
    }

    private void consumeJsonBody(ByteBuffer src, boolean endOfStream) throws IOException {
        this.parser.feedInput(src);
        JsonToken jsonToken = this.parser.nextToken();
        while (jsonToken != null && jsonToken != JsonToken.NOT_AVAILABLE) {
            this.buffer.copyCurrentEvent(this.parser);
            jsonToken = this.parser.nextToken();
        }
        if (endOfStream) {
            this.parser.endOfInput();
        }
    }
}

