/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.response;

import io.camunda.zeebe.client.api.response.PartitionInfo;
import io.camunda.zeebe.client.impl.response.PartitionInfoImpl;
import io.camunda.zeebe.client.protocol.rest.BrokerInfo;
import io.camunda.zeebe.client.protocol.rest.Partition;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.netty.util.NetUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class BrokerInfoImpl
implements io.camunda.zeebe.client.api.response.BrokerInfo {
    private final int nodeId;
    private final String host;
    private final int port;
    private final String version;
    private final List<PartitionInfo> partitions;

    public BrokerInfoImpl(GatewayOuterClass.BrokerInfo grpcBrokerInfo) {
        this.nodeId = grpcBrokerInfo.getNodeId();
        this.host = grpcBrokerInfo.getHost();
        this.port = grpcBrokerInfo.getPort();
        this.version = grpcBrokerInfo.getVersion();
        this.partitions = new ArrayList<PartitionInfo>();
        for (GatewayOuterClass.Partition partition : grpcBrokerInfo.getPartitionsList()) {
            this.partitions.add(new PartitionInfoImpl(partition));
        }
    }

    public BrokerInfoImpl(BrokerInfo httpBrokerInfo) {
        this.nodeId = httpBrokerInfo.getNodeId();
        this.host = httpBrokerInfo.getHost();
        this.port = httpBrokerInfo.getPort();
        this.version = httpBrokerInfo.getVersion();
        this.partitions = new ArrayList<PartitionInfo>();
        httpBrokerInfo.getPartitions().forEach(partition -> this.partitions.add(new PartitionInfoImpl((Partition)partition)));
    }

    @Override
    public int getNodeId() {
        return this.nodeId;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getAddress() {
        return NetUtil.toSocketAddressString(this.host, this.port);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public List<PartitionInfo> getPartitions() {
        return this.partitions;
    }

    public String toString() {
        return "BrokerInfoImpl{nodeId=" + this.nodeId + ", host='" + this.host + '\'' + ", port=" + this.port + ", version=" + this.version + ", partitions=" + this.partitions + '}';
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.host, this.port, this.version, this.partitions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerInfoImpl that = (BrokerInfoImpl)o;
        return this.nodeId == that.nodeId && this.port == that.port && Objects.equals(this.host, that.host) && Objects.equals(this.version, that.version) && Objects.equals(this.partitions, that.partitions);
    }
}

