/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.impl.QueryImpl;
import io.camunda.zeebe.model.bpmn.instance.BpmnModelElementInstance;
import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.ExtensionElements;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.ThrowEvent;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebePublishMessage;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import java.util.Collection;
import java.util.Collections;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class MessageThrowEventValidator
implements ModelElementValidator<ThrowEvent> {
    @Override
    public Class<ThrowEvent> getElementType() {
        return ThrowEvent.class;
    }

    @Override
    public void validate(ThrowEvent element, ValidationResultCollector validationResultCollector) {
        if (this.isMessageThrowEvent(element)) {
            Collection<ZeebeTaskDefinition> taskDefinitionExtensions;
            MessageEventDefinition messageEventDefinition = this.getEventDefinition(element);
            Collection<ZeebePublishMessage> publishMessageExtensions = this.getExtensionElementsByType(messageEventDefinition.getExtensionElements(), ZeebePublishMessage.class);
            if (!this.hasExactlyOneExtension(publishMessageExtensions, taskDefinitionExtensions = this.getExtensionElementsByType(element.getExtensionElements(), ZeebeTaskDefinition.class))) {
                validationResultCollector.addError(0, String.format("Must have either one 'zeebe:%s' or one 'zeebe:%s' extension element", "publishMessage", "taskDefinition"));
            } else if (taskDefinitionExtensions.isEmpty() && messageEventDefinition.getMessage() == null) {
                validationResultCollector.addError(0, "Must reference a message");
            }
        }
    }

    private boolean isMessageThrowEvent(ThrowEvent element) {
        return element.getEventDefinitions().stream().anyMatch(MessageEventDefinition.class::isInstance);
    }

    private MessageEventDefinition getEventDefinition(ThrowEvent event) {
        return new QueryImpl<EventDefinition>(event.getEventDefinitions()).filterByType(MessageEventDefinition.class).singleResult();
    }

    public <T extends BpmnModelElementInstance> Collection<T> getExtensionElementsByType(ExtensionElements extensionElements, Class<T> type) {
        if (extensionElements == null) {
            return Collections.emptyList();
        }
        return extensionElements.getChildElementsByType(type);
    }

    private boolean hasExactlyOneExtension(Collection<ZeebePublishMessage> publishMessageExtensions, Collection<ZeebeTaskDefinition> taskDefinitionExtensions) {
        return publishMessageExtensions.size() == 1 && taskDefinitionExtensions.isEmpty() || publishMessageExtensions.isEmpty() && taskDefinitionExtensions.size() == 1;
    }
}

