/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.BpmnModelElementInstance;
import io.camunda.zeebe.model.bpmn.instance.ExtensionElements;
import io.camunda.zeebe.model.bpmn.instance.SendTask;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebePublishMessage;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import java.util.Collection;
import java.util.Collections;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public final class SendTaskValidator
implements ModelElementValidator<SendTask> {
    @Override
    public Class<SendTask> getElementType() {
        return SendTask.class;
    }

    @Override
    public void validate(SendTask element, ValidationResultCollector validationResultCollector) {
        Collection<ZeebeTaskDefinition> taskDefinitionExtensions;
        ExtensionElements extensionElements = element.getExtensionElements();
        Collection<ZeebePublishMessage> publishMessageExtensions = this.getExtensionElementsByType(extensionElements, ZeebePublishMessage.class);
        if (!this.hasExactlyOneExtension(publishMessageExtensions, taskDefinitionExtensions = this.getExtensionElementsByType(extensionElements, ZeebeTaskDefinition.class))) {
            validationResultCollector.addError(0, String.format("Must have either one 'zeebe:%s' or one 'zeebe:%s' extension element", "publishMessage", "taskDefinition"));
        }
        if (!publishMessageExtensions.isEmpty() && element.getMessage() == null) {
            validationResultCollector.addError(0, "Must reference a message");
        }
    }

    public <T extends BpmnModelElementInstance> Collection<T> getExtensionElementsByType(ExtensionElements extensionElements, Class<T> type) {
        if (extensionElements == null) {
            return Collections.emptyList();
        }
        return extensionElements.getChildElementsByType(type);
    }

    private boolean hasExactlyOneExtension(Collection<ZeebePublishMessage> publishMessageExtensions, Collection<ZeebeTaskDefinition> taskDefinitionExtensions) {
        return publishMessageExtensions.size() == 1 && taskDefinitionExtensions.isEmpty() || publishMessageExtensions.isEmpty() && taskDefinitionExtensions.size() == 1;
    }
}

