/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zeebe;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.zeebe.ZeebeEndpoint;
import org.apache.camel.component.zeebe.internal.OperationName;
import org.apache.camel.component.zeebe.internal.ZeebeService;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="zeebe")
public class ZeebeComponent
extends DefaultComponent {
    @Metadata(defaultValue="localhost", label="security")
    String gatewayHost = "localhost";
    @Metadata(defaultValue="26500", label="security")
    int gatewayPort = 26500;
    @Metadata(label="security", secret=true)
    String clientId;
    @Metadata(label="security", secret=true)
    String clientSecret;
    @Metadata
    String oAuthAPI;
    private ZeebeService zeebeService;

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        OperationName operationName = null;
        operationName = OperationName.fromValue(remaining);
        ZeebeEndpoint endpoint = new ZeebeEndpoint(uri, this, operationName);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    public ZeebeService getZeebeService() {
        return this.zeebeService;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getOAuthAPI() {
        return this.oAuthAPI;
    }

    public void setOAuthAPI(String oAuthAPI) {
        this.oAuthAPI = oAuthAPI;
    }

    public String getGatewayHost() {
        return this.gatewayHost;
    }

    public void setGatewayHost(String gatewayHost) {
        this.gatewayHost = gatewayHost;
    }

    public int getGatewayPort() {
        return this.gatewayPort;
    }

    public void setGatewayPort(int gatewayPort) {
        this.gatewayPort = gatewayPort;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.zeebeService == null) {
            this.zeebeService = new ZeebeService(this.gatewayHost, this.gatewayPort);
            this.zeebeService.doStart();
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.zeebeService != null) {
            this.zeebeService.doStop();
            this.zeebeService = null;
        }
    }
}

