/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.StreamJobsCommandStep1;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.response.StreamJobsResponse;
import io.camunda.zeebe.client.impl.RetriableStreamingFutureImpl;
import io.camunda.zeebe.client.impl.response.ActivatedJobImpl;
import io.camunda.zeebe.client.impl.response.StreamJobsResponseImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class StreamJobsCommandImpl
implements StreamJobsCommandStep1,
StreamJobsCommandStep1.StreamJobsCommandStep2,
StreamJobsCommandStep1.StreamJobsCommandStep3 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final JsonMapper jsonMapper;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private final GatewayOuterClass.StreamActivatedJobsRequest.Builder builder;
    private Consumer<ActivatedJob> consumer;
    private Duration requestTimeout;
    private final Set<String> defaultTenantIds;
    private final Set<String> customTenantIds;

    public StreamJobsCommandImpl(GatewayGrpc.GatewayStub asyncStub, JsonMapper jsonMapper, Predicate<CredentialsProvider.StatusCode> retryPredicate, ZeebeClientConfiguration config) {
        this.asyncStub = asyncStub;
        this.jsonMapper = jsonMapper;
        this.retryPredicate = retryPredicate;
        this.builder = GatewayOuterClass.StreamActivatedJobsRequest.newBuilder();
        this.timeout(config.getDefaultJobTimeout());
        this.workerName(config.getDefaultJobWorkerName());
        this.defaultTenantIds = new HashSet<String>(config.getDefaultJobWorkerTenantIds());
        this.customTenantIds = new HashSet<String>();
    }

    @Override
    public FinalCommandStep<StreamJobsResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<StreamJobsResponse> send() {
        this.builder.clearTenantIds();
        if (this.customTenantIds.isEmpty()) {
            this.builder.addAllTenantIds(this.defaultTenantIds);
        } else {
            this.builder.addAllTenantIds(this.customTenantIds);
        }
        GatewayOuterClass.StreamActivatedJobsRequest request = this.builder.build();
        RetriableStreamingFutureImpl<StreamJobsResponseImpl, GatewayOuterClass.ActivatedJob> result = new RetriableStreamingFutureImpl<StreamJobsResponseImpl, GatewayOuterClass.ActivatedJob>(new StreamJobsResponseImpl(), this::consumeJob, this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.ActivatedJob>)streamObserver));
        this.send(request, result);
        return result;
    }

    private void send(GatewayOuterClass.StreamActivatedJobsRequest request, StreamObserver<GatewayOuterClass.ActivatedJob> observer) {
        GatewayGrpc.GatewayStub stub = this.asyncStub;
        if (this.requestTimeout != null) {
            stub = (GatewayGrpc.GatewayStub)stub.withDeadlineAfter(this.requestTimeout.toNanos(), TimeUnit.NANOSECONDS);
        }
        stub.streamActivatedJobs(request, observer);
    }

    @Override
    public StreamJobsCommandStep1.StreamJobsCommandStep2 jobType(String jobType) {
        this.builder.setType(Objects.requireNonNull(jobType, "must specify a job type"));
        return this;
    }

    @Override
    public StreamJobsCommandStep1.StreamJobsCommandStep3 consumer(Consumer<ActivatedJob> consumer) {
        this.consumer = Objects.requireNonNull(consumer, "must specify a job consumer");
        return this;
    }

    @Override
    public StreamJobsCommandStep1.StreamJobsCommandStep3 timeout(Duration timeout) {
        Objects.requireNonNull(timeout, "must specify a job timeout");
        this.builder.setTimeout(timeout.toMillis());
        return this;
    }

    @Override
    public StreamJobsCommandStep1.StreamJobsCommandStep3 workerName(String workerName) {
        this.builder.setWorker(workerName);
        return this;
    }

    @Override
    public StreamJobsCommandStep1.StreamJobsCommandStep3 fetchVariables(List<String> fetchVariables) {
        this.builder.addAllFetchVariable(fetchVariables);
        return this;
    }

    @Override
    public StreamJobsCommandStep1.StreamJobsCommandStep3 fetchVariables(String ... fetchVariables) {
        return this.fetchVariables(Arrays.asList(fetchVariables));
    }

    @Override
    public StreamJobsCommandStep1.StreamJobsCommandStep3 tenantId(String tenantId) {
        this.customTenantIds.add(tenantId);
        return this;
    }

    @Override
    public StreamJobsCommandStep1.StreamJobsCommandStep3 tenantIds(List<String> tenantIds) {
        this.customTenantIds.clear();
        this.customTenantIds.addAll(tenantIds);
        return this;
    }

    @Override
    public StreamJobsCommandStep1.StreamJobsCommandStep3 tenantIds(String ... tenantIds) {
        return this.tenantIds((List)Arrays.asList(tenantIds));
    }

    private void consumeJob(GatewayOuterClass.ActivatedJob job) {
        ActivatedJobImpl mappedJob = new ActivatedJobImpl(this.jsonMapper, job);
        this.consumer.accept(mappedJob);
    }
}

