/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zeebe.processor;

import com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.component.zeebe.ZeebeEndpoint;
import org.apache.camel.component.zeebe.internal.ZeebeService;
import org.apache.camel.component.zeebe.model.JobRequest;
import org.apache.camel.component.zeebe.model.JobResponse;
import org.apache.camel.component.zeebe.model.JobWorkerMessage;
import org.apache.camel.component.zeebe.processor.AbstractBaseProcessor;

public class JobProcessor
extends AbstractBaseProcessor {
    public JobProcessor(ZeebeEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        JobRequest message = null;
        Long headerJobKey = exchange.getMessage().getHeader("CamelZeebeJobKey", Long.class);
        if (exchange.getMessage().getBody() instanceof JobRequest) {
            message = exchange.getMessage().getBody(JobRequest.class);
        } else if (exchange.getMessage().getBody() instanceof String) {
            try {
                String bodyString = exchange.getMessage().getBody(String.class);
                message = this.objectMapper.readValue(bodyString, JobRequest.class);
            }
            catch (JsonProcessingException jsonProcessingException) {
                throw new IllegalArgumentException("Cannot convert body to JobMessage", jsonProcessingException);
            }
        } else if (exchange.getMessage().getBody() instanceof JobWorkerMessage) {
            JobWorkerMessage jobWorkerMessage = exchange.getMessage().getBody(JobWorkerMessage.class);
            message = new JobRequest();
            message.setJobKey(jobWorkerMessage.getKey());
        } else if (headerJobKey != null) {
            message = new JobRequest();
            message.setJobKey(headerJobKey);
        } else {
            throw new CamelException("Job data missing");
        }
        JobResponse resultMessage = null;
        switch (this.endpoint.getOperationName()) {
            case COMPLETE_JOB: {
                resultMessage = this.completeJob(message);
                break;
            }
            case FAIL_JOB: {
                resultMessage = this.failJob(message);
                break;
            }
            case UPDATE_JOB_RETRIES: {
                resultMessage = this.updateJobRetries(message);
                break;
            }
            case THROW_ERROR: {
                resultMessage = this.throwError(message);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Operation!");
            }
        }
        this.setBody(exchange, resultMessage, this.endpoint.isFormatJSON());
    }

    private JobResponse completeJob(JobRequest message) {
        ZeebeService zeebeService = this.endpoint.getComponent().getZeebeService();
        return zeebeService.completeJob(message);
    }

    private JobResponse failJob(JobRequest message) {
        ZeebeService zeebeService = this.endpoint.getComponent().getZeebeService();
        return zeebeService.failJob(message);
    }

    private JobResponse updateJobRetries(JobRequest message) {
        ZeebeService zeebeService = this.endpoint.getComponent().getZeebeService();
        return zeebeService.updateJobRetries(message);
    }

    private JobResponse throwError(JobRequest message) {
        ZeebeService zeebeService = this.endpoint.getComponent().getZeebeService();
        return zeebeService.throwError(message);
    }
}

