/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.operations;

import org.apache.camel.component.zookeeper.operations.OperationResult;
import org.apache.camel.component.zookeeper.operations.ZooKeeperOperation;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class SetDataOperation
extends ZooKeeperOperation<byte[]> {
    private byte[] data;
    private int version = -1;

    public SetDataOperation(ZooKeeper connection, String node, byte[] data) {
        super(connection, node);
        this.data = data;
    }

    @Override
    public OperationResult<byte[]> getResult() {
        try {
            Stat statistics = this.connection.setData(this.node, this.data, this.version);
            if (LOG.isDebugEnabled()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(String.format("Set data of node '%s'  with '%d' bytes of data, retrieved statistics '%s' ", this.node, this.data != null ? this.data.length : 0, statistics));
                } else {
                    LOG.debug(String.format("Set data of node '%s' with '%d' bytes of data", this.node, this.data != null ? this.data.length : 0));
                }
            }
            return new OperationResult<byte[]>(this.data, statistics);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new OperationResult<byte[]>(e);
        }
        catch (Exception e) {
            return new OperationResult<byte[]>(e);
        }
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public ZooKeeperOperation<?> createCopy() throws Exception {
        SetDataOperation copy = (SetDataOperation)super.createCopy();
        copy.version = -1;
        return copy;
    }
}

